/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;

public class ResourceAccessChange
extends Change {
    private IResource recource;
    private boolean makeWrittable;

    public ResourceAccessChange(IResource recource, boolean makeWrittable) {
        this.recource = recource;
        this.makeWrittable = makeWrittable;
    }

    public String getName() {
        return Messages.bind((String)Messages.ResourceAccess_Message, (Object)this.recource.getFullPath());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        this.checkExistence(result);
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(this.getName(), 1);
            if (this.makeWrittable) {
                WriteAccessChecker.setWritable(this.recource, true);
                ResourceAccessChange resourceAccessChange = new ResourceAccessChange(this.recource, false);
                return resourceAccessChange;
            }
            WriteAccessChecker.setWritable(this.recource, false);
            ResourceAccessChange resourceAccessChange = new ResourceAccessChange(this.recource, true);
            return resourceAccessChange;
        }
        finally {
            pm.done();
        }
    }

    public Object getModifiedElement() {
        return this.recource;
    }

    private void checkExistence(RefactoringStatus status) {
        if (this.recource == null) {
            status.addFatalError("No input element provided");
        } else if (!this.recource.exists()) {
            status.addFatalError("\"" + this.recource.getFullPath() + "\" does not exist anymore.");
        }
    }
}

