/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.mylyn.rcp;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContextManager;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.mylyn.rcp.l10n.Messages;

public class MylynSessionProcessor
extends SessionProcessor {
    private IInteractionContextManager contextManager;
    private float minInterest;

    public boolean startSession(IRecommendersCompletionContext crContext) {
        this.contextManager = ContextCore.getContextManager();
        this.minInterest = ContextCore.getCommonContextScaling().getInteresting();
        return this.contextManager.isContextActive();
    }

    public void process(IProcessableProposal p) throws Exception {
        if (!(p instanceof AbstractJavaCompletionProposal)) {
            return;
        }
        AbstractJavaCompletionProposal proposal = (AbstractJavaCompletionProposal)p;
        IJavaElement javaElement = proposal.getJavaElement();
        if (javaElement == null) {
            return;
        }
        String handle = javaElement.getHandleIdentifier();
        IInteractionElement interactionElement = this.contextManager.getElement(handle);
        if (interactionElement == null) {
            return;
        }
        float interest = interactionElement.getInterest().getValue();
        if (interest > this.minInterest) {
            String label = MessageFormat.format(Messages.PROPOSAL_LABEL_MYLYN_INTEREST, Float.valueOf(interest));
            ProposalProcessorManager proposalMgr = p.getProposalProcessorManager();
            SimpleProposalProcessor processor = new SimpleProposalProcessor(Math.round(interest), label);
            proposalMgr.addProcessor((ProposalProcessor)processor);
        }
    }

    public void endSession(List<ICompletionProposal> proposals) {
        this.contextManager = null;
    }
}

