/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.RequiredConstraintService;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class RequiredConstraintFactsService
extends FactsService {
    @Text(value="Must be specified")
    private static LocalizableText statement;
    private Property property;
    private RequiredConstraintService requiredConstraintService;
    private Listener listener;

    static {
        LocalizableText.init(RequiredConstraintFactsService.class);
    }

    @Override
    protected void init() {
        super.init();
        this.property = this.context(Property.class);
        this.requiredConstraintService = this.property.service(RequiredConstraintService.class);
        this.listener = new Listener(){

            @Override
            public void handle(Event event) {
                RequiredConstraintFactsService.this.broadcast();
            }
        };
        this.requiredConstraintService.attach(this.listener);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        if (this.requiredConstraintService.required()) {
            Value value;
            boolean applicable = true;
            if (this.property instanceof Value && (value = (Value)this.property).getDefaultText() != null) {
                applicable = false;
            }
            if (applicable) {
                facts.add(statement.text());
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.requiredConstraintService.detach(this.listener);
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            return property != null && property.service(RequiredConstraintService.class) != null;
        }
    }
}

