/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.Rendezvous;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class BlockingFileSystemProxy
implements IFileSystem {
    private static final long DEFAULT_TIMEOUT = 60000L;
    IFileSystem service;

    public BlockingFileSystemProxy(IFileSystem service) {
        Assert.isNotNull((Object)service);
        this.service = service;
    }

    public String getName() {
        return this.service.getName();
    }

    public IToken open(final String file_name, final int flags, final IFileSystem.FileAttrs attrs, final IFileSystem.DoneOpen done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.open(file_name, flags, attrs, new IFileSystem.DoneOpen(){

                    public void doneOpen(final IToken token, final IFileSystem.FileSystemException error, final IFileSystem.IFileHandle handle) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneOpen(token, error, handle);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutOpeningFile, (Object)file_name));
        }
        return (IToken)ref.get();
    }

    public IToken close(final IFileSystem.IFileHandle handle, final IFileSystem.DoneClose done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.close(handle, new IFileSystem.DoneClose(){

                    public void doneClose(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneClose(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutClosingFile, (Object)handle));
        }
        return (IToken)ref.get();
    }

    public IToken read(final IFileSystem.IFileHandle handle, final long offset, final int len, final IFileSystem.DoneRead done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.read(handle, offset, len, new IFileSystem.DoneRead(){

                    public void doneRead(final IToken token, final IFileSystem.FileSystemException error, final byte[] data, final boolean eof) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneRead(token, error, data, eof);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutReadingFile, (Object)handle));
        }
        return (IToken)ref.get();
    }

    public IToken write(final IFileSystem.IFileHandle handle, final long offset, final byte[] data, final int data_pos, final int data_size, final IFileSystem.DoneWrite done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.write(handle, offset, data, data_pos, data_size, new IFileSystem.DoneWrite(){

                    public void doneWrite(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneWrite(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutWritingFile, (Object)handle));
        }
        return (IToken)ref.get();
    }

    public IToken stat(final String path, final IFileSystem.DoneStat done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.stat(path, new IFileSystem.DoneStat(){

                    public void doneStat(final IToken token, final IFileSystem.FileSystemException error, final IFileSystem.FileAttrs attrs) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneStat(token, error, attrs);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutStat, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken lstat(final String path, final IFileSystem.DoneStat done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.lstat(path, new IFileSystem.DoneStat(){

                    public void doneStat(final IToken token, final IFileSystem.FileSystemException error, final IFileSystem.FileAttrs attrs) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneStat(token, error, attrs);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutLstat, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken fstat(final IFileSystem.IFileHandle handle, final IFileSystem.DoneStat done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.fstat(handle, new IFileSystem.DoneStat(){

                    public void doneStat(final IToken token, final IFileSystem.FileSystemException error, final IFileSystem.FileAttrs attrs) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneStat(token, error, attrs);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutFstat, (Object)handle));
        }
        return (IToken)ref.get();
    }

    public IToken setstat(final String path, final IFileSystem.FileAttrs attrs, final IFileSystem.DoneSetStat done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.setstat(path, attrs, new IFileSystem.DoneSetStat(){

                    public void doneSetStat(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneSetStat(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutSetStat, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken fsetstat(final IFileSystem.IFileHandle handle, final IFileSystem.FileAttrs attrs, final IFileSystem.DoneSetStat done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.fsetstat(handle, attrs, new IFileSystem.DoneSetStat(){

                    public void doneSetStat(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneSetStat(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutFSetStat, (Object)handle));
        }
        return (IToken)ref.get();
    }

    public IToken opendir(final String path, final IFileSystem.DoneOpen done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.opendir(path, new IFileSystem.DoneOpen(){

                    public void doneOpen(final IToken token, final IFileSystem.FileSystemException error, final IFileSystem.IFileHandle handle) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneOpen(token, error, handle);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutOpeningDir, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken readdir(final IFileSystem.IFileHandle handle, final IFileSystem.DoneReadDir done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.readdir(handle, new IFileSystem.DoneReadDir(){

                    public void doneReadDir(final IToken token, final IFileSystem.FileSystemException error, final IFileSystem.DirEntry[] entries, final boolean eof) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneReadDir(token, error, entries, eof);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutReadingDir, (Object)handle));
        }
        return (IToken)ref.get();
    }

    public IToken mkdir(final String path, final IFileSystem.FileAttrs attrs, final IFileSystem.DoneMkDir done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.mkdir(path, attrs, new IFileSystem.DoneMkDir(){

                    public void doneMkDir(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneMkDir(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutMakingDir, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken rmdir(final String path, final IFileSystem.DoneRemove done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.rmdir(path, new IFileSystem.DoneRemove(){

                    public void doneRemove(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneRemove(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutRemovingDir, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken roots(final IFileSystem.DoneRoots done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.roots(new IFileSystem.DoneRoots(){

                    public void doneRoots(final IToken token, final IFileSystem.FileSystemException error, final IFileSystem.DirEntry[] entries) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneRoots(token, error, entries);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(Messages.BlockingFileSystemProxy_TimeoutListingRoots);
        }
        return (IToken)ref.get();
    }

    public IToken remove(final String file_name, final IFileSystem.DoneRemove done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.remove(file_name, new IFileSystem.DoneRemove(){

                    public void doneRemove(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneRemove(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutRemovingFile, (Object)file_name));
        }
        return (IToken)ref.get();
    }

    public IToken realpath(final String path, final IFileSystem.DoneRealPath done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.realpath(path, new IFileSystem.DoneRealPath(){

                    public void doneRealPath(final IToken token, final IFileSystem.FileSystemException error, final String path) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneRealPath(token, error, path);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutGettingRealPath, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken rename(final String old_path, final String new_path, final IFileSystem.DoneRename done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.rename(old_path, new_path, new IFileSystem.DoneRename(){

                    public void doneRename(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneRename(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutRenamingFile, (Object)old_path, (Object)new_path));
        }
        return (IToken)ref.get();
    }

    public IToken readlink(final String path, final IFileSystem.DoneReadLink done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.readlink(path, new IFileSystem.DoneReadLink(){

                    public void doneReadLink(final IToken token, final IFileSystem.FileSystemException error, final String path) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneReadLink(token, error, path);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutReadingLink, (Object)path));
        }
        return (IToken)ref.get();
    }

    public IToken symlink(final String link_path, final String target_path, final IFileSystem.DoneSymLink done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.symlink(link_path, target_path, new IFileSystem.DoneSymLink(){

                    public void doneSymLink(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneSymLink(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutSymLink, (Object)link_path, (Object)target_path));
        }
        return (IToken)ref.get();
    }

    public IToken copy(final String src_path, final String dst_path, final boolean copy_permissions, final boolean copy_ownership, final IFileSystem.DoneCopy done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.copy(src_path, dst_path, copy_permissions, copy_ownership, new IFileSystem.DoneCopy(){

                    public void doneCopy(final IToken token, final IFileSystem.FileSystemException error) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneCopy(token, error);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(NLS.bind((String)Messages.BlockingFileSystemProxy_TimeoutCopying, (Object)src_path, (Object)dst_path));
        }
        return (IToken)ref.get();
    }

    public IToken user(final IFileSystem.DoneUser done) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final Rendezvous rendezvous = new Rendezvous();
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IToken token = BlockingFileSystemProxy.this.service.user(new IFileSystem.DoneUser(){

                    public void doneUser(final IToken token, final IFileSystem.FileSystemException error, final int real_uid, final int effective_uid, final int real_gid, final int effective_gid, final String home) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                done.doneUser(token, error, real_uid, effective_uid, real_gid, effective_gid, home);
                            }
                        });
                        rendezvous.arrive();
                    }
                });
                ref.set(token);
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(Messages.BlockingFileSystemProxy_TimeoutGettingUser);
        }
        return (IToken)ref.get();
    }
}

