/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.FileStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.TagFileSender;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.TagListener;

public class Tag
extends Command {
    public static final Command.LocalOption CREATE_BRANCH = new Command.LocalOption("-b", null);
    public static final Command.LocalOption FORCE_REASSIGNMENT = new Command.LocalOption("-F", null);
    private static final ICommandOutputListener DEFAULT_OUTPUT_LISTENER = new TagListener();
    private boolean customBehaviorEnabled;

    protected Tag(boolean customBehaviorEnabled) {
        this.customBehaviorEnabled = customBehaviorEnabled;
    }

    protected Tag() {
        this(false);
    }

    @Override
    protected String getRequestId() {
        return "tag";
    }

    @Override
    protected ICVSResource[] computeWorkResources(Session session, Command.LocalOption[] localOptions, String[] arguments) throws CVSException {
        if (arguments.length < 1) {
            throw new IllegalArgumentException();
        }
        String[] allButFirst = new String[arguments.length - 1];
        System.arraycopy(arguments, 1, allButFirst, 0, arguments.length - 1);
        return super.computeWorkResources(session, localOptions, allButFirst);
    }

    public IStatus execute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, CVSTag tag, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        if (tag.getType() != 2 && tag.getType() != 1) {
            throw new CVSException((IStatus)new CVSStatus(4, CVSMessages.Tag_notVersionOrBranchError));
        }
        if (tag.getType() == 1 && !CREATE_BRANCH.isElementOf(localOptions)) {
            Command.LocalOption[] newLocalOptions = new Command.LocalOption[localOptions.length + 1];
            System.arraycopy(localOptions, 0, newLocalOptions, 0, localOptions.length);
            newLocalOptions[newLocalOptions.length - 1] = CREATE_BRANCH;
            localOptions = newLocalOptions;
        }
        String[] newArguments = new String[arguments.length + 1];
        newArguments[0] = tag.getName();
        System.arraycopy(arguments, 0, newArguments, 1, arguments.length);
        return this.execute(session, globalOptions, localOptions, newArguments, listener, monitor);
    }

    public IStatus execute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, CVSTag tag, ICVSResource[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        String[] stringArguments = this.convertArgumentsForOpenSession(arguments, session);
        return this.execute(session, globalOptions, localOptions, tag, stringArguments, listener, monitor);
    }

    @Override
    protected ICommandOutputListener getDefaultCommandOutputListener() {
        return DEFAULT_OUTPUT_LISTENER;
    }

    @Override
    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        if (this.customBehaviorEnabled) {
            new TagFileSender(session, localOptions).visit(session, resources, monitor);
        } else {
            new FileStructureVisitor(session, localOptions, false, false).visit(session, resources, monitor);
        }
        return resources;
    }
}

