/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.callstack;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEntry;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEvent;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class CallStackPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;
    private static final StateItem[] STATE_TABLE;
    private CallStackView fView;
    private Integer fMinimumBarWidth;
    private final LoadingCache<CallStackEvent, Optional<String>> fTimeEventNames = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CallStackEvent, Optional<String>>(){

        public Optional<String> load(CallStackEvent event) {
            CallStackEntry entry = event.getEntry();
            ITmfStateSystem ss = entry.getStateSystem();
            try {
                ITmfStateValue value = ss.querySingleState(event.getTime(), entry.getQuark()).getStateValue();
                if (!value.isNull()) {
                    String name = CallStackPresentationProvider.this.fView.getFunctionName(entry.getTrace(), entry.getProcessId(), event.getTime(), value);
                    return Optional.ofNullable(name);
                }
            }
            catch (TimeRangeException e) {
                Activator.getDefault().logError("Error querying state system", e);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
            return Optional.empty();
        }
    });

    static {
        float saturation = 0.6f;
        float brightness = 0.6f;
        STATE_TABLE = new StateItem[361];
        CallStackPresentationProvider.STATE_TABLE[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        int i = 0;
        while (i < 360) {
            RGB rgb = new RGB((float)i, 0.6f, 0.6f);
            CallStackPresentationProvider.STATE_TABLE[i + 1] = new StateItem(rgb, State.EXEC.toString());
            ++i;
        }
    }

    public void setCallStackView(CallStackView view) {
        this.fView = view;
    }

    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        return Messages.CallStackPresentationProvider_Thread;
    }

    @Override
    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    @Override
    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof CallStackEvent) {
            CallStackEvent callStackEvent = (CallStackEvent)event;
            return callStackEvent.getValue() + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    @Override
    public String getEventName(ITimeEvent event) {
        if (event instanceof CallStackEvent) {
            return ((Optional)this.fTimeEventNames.getUnchecked((Object)((CallStackEvent)event))).orElse(null);
        }
        return State.MULTIPLE.toString();
    }

    @Override
    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (!(event instanceof CallStackEvent)) {
            return;
        }
        if (this.fMinimumBarWidth == null) {
            this.fMinimumBarWidth = gc.getFontMetrics().getAverageCharWidth() + gc.stringExtent((String)"\u2026").x;
        }
        if (bounds.width <= this.fMinimumBarWidth) {
            return;
        }
        String name = ((Optional)this.fTimeEventNames.getUnchecked((Object)((CallStackEvent)event))).orElse("");
        if (name.isEmpty()) {
            return;
        }
        gc.setForeground(gc.getDevice().getSystemColor(1));
        Utils.drawText(gc, name, bounds.x, bounds.y, bounds.width, bounds.height, true, true);
    }

    void resetFunctionNames() {
        this.fTimeEventNames.invalidateAll();
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

