/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.resolver;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.evm.specific.resolver.FixedPriorityConflictResolver;

public class FixedPriorityConflictSet
implements ChangeableConflictSet {
    protected final Multimap<Integer, Activation<?>> priorityBuckets;
    private Map<RuleSpecification<?>, Integer> priorityMap;
    private FixedPriorityConflictResolver resolver;

    public FixedPriorityConflictSet(FixedPriorityConflictResolver resolver, Map<RuleSpecification<?>, Integer> priorities) {
        SetMultimap multimap;
        this.resolver = resolver;
        Preconditions.checkArgument((priorities != null ? 1 : 0) != 0, (Object)"Priority map cannot be null!");
        this.priorityMap = Maps.newHashMap(priorities);
        TreeMap treeMap = new TreeMap();
        this.priorityBuckets = multimap = Multimaps.newSetMultimap(treeMap, (Supplier)new Supplier<Set<Activation<?>>>(){

            public Set<Activation<?>> get() {
                return new HashSet();
            }
        });
    }

    @Override
    public Activation<?> getNextActivation() {
        Collection<Activation<?>> firstBucket = this.getFirstBucket();
        if (!firstBucket.isEmpty()) {
            return firstBucket.iterator().next();
        }
        return null;
    }

    private Collection<Activation<?>> getFirstBucket() {
        if (this.priorityBuckets.isEmpty()) {
            return Collections.emptySet();
        }
        Integer firstKey = (Integer)this.priorityBuckets.keySet().iterator().next();
        Collection firstBucket = this.priorityBuckets.get((Object)firstKey);
        return firstBucket;
    }

    @Override
    public boolean addActivation(Activation<?> activation) {
        Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (Object)"Activation cannot be null!");
        Integer rulePriority = this.getRulePriority(activation);
        return this.priorityBuckets.put((Object)rulePriority, activation);
    }

    @Override
    public boolean removeActivation(Activation<?> activation) {
        Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (Object)"Activation cannot be null!");
        Integer rulePriority = this.getRulePriority(activation);
        return this.priorityBuckets.remove((Object)rulePriority, activation);
    }

    protected void setPriority(RuleSpecification<?> specification, int priority) {
        Preconditions.checkArgument((specification != null ? 1 : 0) != 0, (Object)"Specification cannot be null");
        Integer rulePriority = this.getRulePriority(specification);
        this.priorityMap.put(specification, priority);
        HashSet<Activation> removed = new HashSet<Activation>();
        for (Activation act : this.priorityBuckets.get((Object)rulePriority)) {
            if (!specification.equals(act.getInstance().getSpecification())) continue;
            removed.add(act);
        }
        this.priorityBuckets.get((Object)rulePriority).removeAll(removed);
        this.priorityBuckets.putAll((Object)priority, removed);
    }

    @Override
    public FixedPriorityConflictResolver getConflictResolver() {
        return this.resolver;
    }

    @Override
    public Set<Activation<?>> getNextActivations() {
        return Collections.unmodifiableSet(Sets.newHashSet(this.getFirstBucket()));
    }

    @Override
    public Set<Activation<?>> getConflictingActivations() {
        return Collections.unmodifiableSet(Sets.newHashSet((Iterable)this.priorityBuckets.values()));
    }

    protected Integer getRulePriority(Activation<?> activation) {
        RuleSpecification<?> specification = activation.getInstance().getSpecification();
        return this.getRulePriority(specification);
    }

    protected Integer getRulePriority(RuleSpecification<?> specification) {
        Integer rulePriority = 0;
        if (this.priorityMap.containsKey(specification)) {
            rulePriority = this.priorityMap.get(specification);
        }
        return rulePriority;
    }
}

