/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generation;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;

public final class GenerationUtils {
    private GenerationUtils() {
    }

    public static VariableSupport getVariableSupport(JavaInfo javaInfo) throws Exception {
        VariableSupportDescription description = GenerationUtils.getVariableDescription(javaInfo);
        return description.createSupport(javaInfo);
    }

    public static VariableSupportDescription getVariableDescription(JavaInfo javaInfo) {
        GenerationSettings generationSettings = GenerationUtils.getToolkit(javaInfo).getGenerationSettings();
        return generationSettings.getVariable(javaInfo);
    }

    public static StatementGenerator getStatementGenerator(JavaInfo javaInfo) throws Exception {
        GenerationSettings generationSettings = GenerationUtils.getToolkit(javaInfo).getGenerationSettings();
        StatementGeneratorDescription description = generationSettings.getStatement(javaInfo);
        return description.get();
    }

    private static ToolkitDescriptionJava getToolkit(JavaInfo javaInfo) {
        return javaInfo.getDescription().getToolkit();
    }
}

