/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionContainer;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionManagementException;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionProxy;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class StructuredDocumentRegionChecker {
    String EOL = System.getProperty("line.separator");
    private int offset = 0;
    Writer testWriter = null;

    public StructuredDocumentRegionChecker() {
    }

    public StructuredDocumentRegionChecker(Writer writer) {
        this.testWriter = writer;
    }

    private void checkChildNodes(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            this.checkNode(child);
            child = child.getNextSibling();
        }
    }

    public void checkModel(IDOMModel model) {
        this.checkChildNodes(model.getDocument());
    }

    private void checkNode(Node node) {
        this.checkStructuredDocumentRegion(((NodeImpl)node).getStructuredDocumentRegion());
        if (node.getNodeType() == 1) {
            this.checkChildNodes(node);
            this.checkStructuredDocumentRegion(((ElementImpl)node).getEndStructuredDocumentRegion());
        }
    }

    private void checkStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        int end;
        if (flatNode == null) {
            return;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int n = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < n) {
                IStructuredDocumentRegion c = container.getStructuredDocumentRegion(i);
                if (c == null) {
                    this.reportError("null");
                } else {
                    this.checkStructuredDocumentRegion(c);
                }
                ++i;
            }
            return;
        }
        int start = flatNode.getStart();
        if (start < this.offset) {
            this.reportError("overwrap");
        }
        if (start > this.offset) {
            this.reportError("gap");
        }
        this.offset = end = flatNode.getEnd();
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
            IStructuredDocumentRegion p = proxy.getStructuredDocumentRegion();
            if (p == null) {
                this.reportError("null");
                return;
            }
            int s = p.getStart();
            int e = p.getEnd();
            if (s > start || e < end) {
                this.reportError("out");
            }
            if (s == start && e == end) {
                this.reportWarning("vain");
            }
        }
    }

    private void reportError(String message) {
        String msg = "StructuredDocumentRegionChecker : error : " + message;
        if (this.testWriter != null) {
            try {
                this.testWriter.write(String.valueOf(msg) + this.EOL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(msg);
        }
        throw new StructuredDocumentRegionManagementException();
    }

    private void reportWarning(String message) {
        String msg = "StructuredDocumentRegionChecker : warning : " + message;
        if (this.testWriter != null) {
            try {
                this.testWriter.write(String.valueOf(msg) + this.EOL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(msg);
        }
    }
}

