/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Provider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.resource.OutdatedStateManager;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.PresentationDamager;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractDamagerRepairerTest
extends Assert
implements IDocumentListener,
ITokenScanner {
    private IPresentationDamager damager;
    protected IRegion lastRegion;
    protected OutdatedStateManager outdatedStateManager = new OutdatedStateManager();
    protected OperationCanceledManager operationCanceledManager = new OperationCanceledManager();

    @Before
    public void setUp() throws Exception {
        this.damager = this.createRegionDamager();
    }

    @After
    public void tearDown() throws Exception {
        this.damager = null;
        this.lastRegion = null;
    }

    protected IRegion check(String before, int start, int replaceLength, String text) throws Exception {
        Document doc = this.createDocument(before);
        this.damager.setDocument((IDocument)doc);
        doc.addDocumentListener((IDocumentListener)this);
        doc.replace(start, replaceLength, text);
        return this.lastRegion;
    }

    protected IPresentationDamager createRegionDamager() {
        return new PresentationDamager();
    }

    protected abstract Lexer createLexer();

    protected Document createDocument(String before) throws Exception {
        DocumentTokenSource source = new DocumentTokenSource();
        source.setLexer((Provider)new Provider<Lexer>(){

            public Lexer get() {
                return AbstractDamagerRepairerTest.this.createLexer();
            }
        });
        XtextDocument document = new XtextDocument(source, null, this.outdatedStateManager, this.operationCanceledManager);
        document.set(before);
        return document;
    }

    protected void assertEquals(int expStart, int expLength, IRegion actual) {
        AbstractDamagerRepairerTest.assertEquals((String)"offset", (long)expStart, (long)actual.getOffset());
        AbstractDamagerRepairerTest.assertEquals((String)"length", (long)expLength, (long)actual.getLength());
    }

    public void documentChanged(DocumentEvent event) {
        this.lastRegion = this.damager.getDamageRegion((ITypedRegion)new TypedRegion(0, event.getDocument().getLength(), "__dftl_partition_content_type"), event, false);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void setRange(IDocument document, int offset, int length) {
    }

    public IToken nextToken() {
        return null;
    }

    public int getTokenOffset() {
        return 0;
    }

    public int getTokenLength() {
        return 0;
    }
}

