/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleUses;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;
import org.eclipse.zest.layouts.progress.ProgressEvent;
import org.eclipse.zest.layouts.progress.ProgressListener;

public class SimpleSwingExample {
    private static final Color NODE_NORMAL_COLOR = new Color(225, 225, 255);
    private static final Color NODE_SELECTED_COLOR = new Color(255, 125, 125);
    private static final Color BORDER_NORMAL_COLOR = new Color(0, 0, 0);
    private static final Color BORDER_SELECTED_COLOR = new Color(255, 0, 0);
    private static final Stroke BORDER_NORMAL_STROKE = new BasicStroke(1.0f);
    private static final Stroke BORDER_SELECTED_STROKE = new BasicStroke(2.0f);
    private static final Color RELATIONSHIP_NORMAL_COLOR = Color.BLUE;
    public static SpringLayoutAlgorithm SPRING = new SpringLayoutAlgorithm(0);
    public static TreeLayoutAlgorithm TREE_VERT = new TreeLayoutAlgorithm(0);
    public static HorizontalTreeLayoutAlgorithm TREE_HORIZ = new HorizontalTreeLayoutAlgorithm(0);
    public static RadialLayoutAlgorithm RADIAL = new RadialLayoutAlgorithm(0);
    public static GridLayoutAlgorithm GRID = new GridLayoutAlgorithm(0);
    public static HorizontalLayoutAlgorithm HORIZ = new HorizontalLayoutAlgorithm(0);
    public static VerticalLayoutAlgorithm VERT = new VerticalLayoutAlgorithm(0);
    private List algorithms = new ArrayList();
    private List algorithmNames = new ArrayList();
    private static final int INITIAL_PANEL_WIDTH = 700;
    private static final int INITIAL_PANEL_HEIGHT = 500;
    private static final boolean RENDER_HIGH_QUALITY = true;
    private static final double INITIAL_NODE_WIDTH = 20.0;
    private static final double INITIAL_NODE_HEIGHT = 20.0;
    private static final int ARROW_HALF_WIDTH = 4;
    private static final int ARROW_HALF_HEIGHT = 6;
    private static final Shape ARROW_SHAPE;
    private static final Stroke ARROW_BORDER_STROKE;
    private static final Color ARROW_HEAD_FILL_COLOR;
    private static final Color ARROW_HEAD_BORDER_COLOR;
    public static final String DEFAULT_NODE_SHAPE = "oval";
    private long updateGUICount = 0L;
    private JFrame mainFrame;
    private JPanel mainPanel;
    private List entities;
    private List relationships;
    private JToolBar toolBar;
    private JLabel lblProgress;
    private JToggleButton btnContinuous;
    private JToggleButton btnAsynchronous;
    private JButton btnStop;
    private LayoutAlgorithm currentLayoutAlgorithm;
    protected String currentLayoutAlgorithmName;
    protected SimpleNode selectedEntity;
    protected Point mouseDownPoint;
    protected Point selectedEntityPositionAtMouseDown;
    private long idCount;
    protected String currentNodeShape = "oval";

    static {
        int[] nArray = new int[3];
        nArray[0] = -4;
        nArray[2] = 4;
        ARROW_SHAPE = new Polygon(new int[]{-6, 6, -6}, nArray, 3);
        ARROW_BORDER_STROKE = new BasicStroke(0.5f);
        ARROW_HEAD_FILL_COLOR = new Color(125, 255, 125);
        ARROW_HEAD_BORDER_COLOR = Color.BLACK;
    }

    protected void addAlgorithm(LayoutAlgorithm algorithm, String name, boolean animate) {
        this.algorithms.add(algorithm);
        this.algorithmNames.add(name);
    }

    public void start() {
        this.mainFrame = new JFrame("Simple Swing Layout Example");
        this.toolBar = new JToolBar();
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.toolBar, "North");
        this.lblProgress = new JLabel("Progress: ");
        this.mainFrame.getContentPane().add((Component)this.lblProgress, "South");
        this.createMainPanel();
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SimpleSwingExample.this.stop();
                SimpleSwingExample.this.mainFrame.dispose();
            }
        });
        this.btnContinuous = new JToggleButton("continuous", false);
        this.btnAsynchronous = new JToggleButton("asynchronous", false);
        this.toolBar.add(this.btnContinuous);
        this.toolBar.add(this.btnAsynchronous);
        this.btnStop = new JButton("Stop");
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSwingExample.this.stop();
            }
        });
        this.toolBar.add(this.btnStop);
        JButton btnCreateGraph = new JButton("New graph");
        btnCreateGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSwingExample.this.stop();
                SimpleSwingExample.this.createGraph(true);
            }
        });
        this.toolBar.add(btnCreateGraph);
        JButton btnCreateTree = new JButton("New tree");
        btnCreateTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSwingExample.this.stop();
                SimpleSwingExample.this.createGraph(false);
            }
        });
        this.toolBar.add(btnCreateTree);
        this.createGraph(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setLocation((int)(screenSize.getWidth() - 700.0) / 2, (int)(screenSize.getHeight() - 500.0) / 2);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.mainFrame.repaint();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SPRING = new SpringLayoutAlgorithm(0);
                    TREE_VERT = new TreeLayoutAlgorithm(0);
                    TREE_HORIZ = new HorizontalTreeLayoutAlgorithm(0);
                    RADIAL = new RadialLayoutAlgorithm(0);
                    GRID = new GridLayoutAlgorithm(0);
                    HORIZ = new HorizontalLayoutAlgorithm(0);
                    VERT = new VerticalLayoutAlgorithm(0);
                    SPRING.setIterations(1000);
                    TREE_VERT.setComparator(new Comparator(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                                return ((Comparable)o1).compareTo(o2);
                            }
                            return 0;
                        }
                    });
                    GRID.setRowPadding(20);
                    SimpleSwingExample.this.addAlgorithm(SPRING, "Spring", false);
                    SimpleSwingExample.this.addAlgorithm(TREE_VERT, "Tree-V", false);
                    SimpleSwingExample.this.addAlgorithm(TREE_HORIZ, "Tree-H", false);
                    SimpleSwingExample.this.addAlgorithm(RADIAL, "Radial", false);
                    SimpleSwingExample.this.addAlgorithm(GRID, "Grid", false);
                    SimpleSwingExample.this.addAlgorithm(HORIZ, "Horiz", false);
                    SimpleSwingExample.this.addAlgorithm(VERT, "Vert", false);
                    int i = 0;
                    while (i < SimpleSwingExample.this.algorithms.size()) {
                        LayoutAlgorithm algorithm = (LayoutAlgorithm)SimpleSwingExample.this.algorithms.get(i);
                        String algorithmName = (String)SimpleSwingExample.this.algorithmNames.get(i);
                        JButton algorithmButton = new JButton(algorithmName);
                        algorithmButton.addActionListener(new ActionListener(this, algorithm, algorithmName){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ LayoutAlgorithm val$algorithm;
                            private final /* synthetic */ String val$algorithmName;
                            {
                                this.this$1 = var1_1;
                                this.val$algorithm = layoutAlgorithm;
                                this.val$algorithmName = string;
                            }

                            public void actionPerformed(ActionEvent e) {
                                SimpleSwingExample.access$19(5.access$0(this.this$1), this.val$algorithm);
                                5.access$0(this.this$1).currentLayoutAlgorithmName = this.val$algorithmName;
                                this.val$algorithm.setEntityAspectRatio((double)SimpleSwingExample.access$20(5.access$0(this.this$1)).getWidth() / (double)SimpleSwingExample.access$20(5.access$0(this.this$1)).getHeight());
                                5.access$0(this.this$1).performLayout();
                            }
                        });
                        SimpleSwingExample.this.toolBar.add(algorithmButton);
                        ++i;
                    }
                }

                static /* synthetic */ SimpleSwingExample access$0(5 var0) {
                    return var0.SimpleSwingExample.this;
                }
            });
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    private void stop() {
        if (this.currentLayoutAlgorithm != null && this.currentLayoutAlgorithm.isRunning()) {
            this.currentLayoutAlgorithm.stop();
        }
    }

    protected void performLayout() {
        this.stop();
        final Cursor cursor = this.mainFrame.getCursor();
        this.updateGUICount = 0L;
        this.placeRandomly();
        final boolean continuous = this.btnContinuous.isSelected();
        final boolean asynchronous = this.btnAsynchronous.isSelected();
        ProgressListener progressListener = new ProgressListener(){

            public void progressUpdated(ProgressEvent e) {
                SimpleSwingExample.this.updateGUI();
                SimpleSwingExample.this.lblProgress.setText("Progress: " + e.getStepsCompleted() + " of " + e.getTotalNumberOfSteps() + " completed ...");
                SimpleSwingExample.this.lblProgress.paintImmediately(0, 0, SimpleSwingExample.this.lblProgress.getWidth(), SimpleSwingExample.this.lblProgress.getHeight());
            }

            public void progressStarted(ProgressEvent e) {
                if (!asynchronous) {
                    SimpleSwingExample.this.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                }
                SimpleSwingExample.this.lblProgress.setText("Layout started ...");
                SimpleSwingExample.this.lblProgress.paintImmediately(0, 0, SimpleSwingExample.this.lblProgress.getWidth(), SimpleSwingExample.this.lblProgress.getHeight());
            }

            public void progressEnded(ProgressEvent e) {
                SimpleSwingExample.this.lblProgress.setText("Layout completed ...");
                SimpleSwingExample.this.lblProgress.paintImmediately(0, 0, SimpleSwingExample.this.lblProgress.getWidth(), SimpleSwingExample.this.lblProgress.getHeight());
                SimpleSwingExample.this.currentLayoutAlgorithm.removeProgressListener(this);
                if (!asynchronous) {
                    SimpleSwingExample.this.mainFrame.setCursor(cursor);
                }
            }
        };
        this.currentLayoutAlgorithm.addProgressListener(progressListener);
        try {
            final LayoutEntity[] layoutEntities = new LayoutEntity[this.entities.size()];
            this.entities.toArray(layoutEntities);
            final LayoutRelationship[] layoutRelationships = new LayoutRelationship[this.relationships.size()];
            this.relationships.toArray(layoutRelationships);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        SimpleSwingExample.this.currentLayoutAlgorithm.applyLayout(layoutEntities, layoutRelationships, 0.0, 0.0, SimpleSwingExample.this.mainPanel.getWidth(), SimpleSwingExample.this.mainPanel.getHeight(), asynchronous, continuous);
                    }
                    catch (InvalidLayoutConfiguration e) {
                        e.printStackTrace();
                    }
                }
            });
            this.updateGUI();
            this.currentNodeShape = DEFAULT_NODE_SHAPE;
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
        }
    }

    private void createMainPanel() {
        this.mainPanel = new MainPanel();
        this.mainPanel.setPreferredSize(new Dimension(700, 500));
        this.mainPanel.setBackground(Color.WHITE);
        this.mainPanel.setLayout(null);
        this.mainFrame.getContentPane().add((Component)new JScrollPane(this.mainPanel), "Center");
        this.mainPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                SimpleSwingExample.this.selectedEntity = null;
                Iterator iter = SimpleSwingExample.this.entities.iterator();
                while (iter.hasNext() && SimpleSwingExample.this.selectedEntity == null) {
                    double h;
                    double w;
                    double y;
                    SimpleNode entity = (SimpleNode)iter.next();
                    double x = entity.getX();
                    Rectangle2D.Double rect = new Rectangle2D.Double(x, y = entity.getY(), w = entity.getWidth(), h = entity.getHeight());
                    if (!rect.contains(e.getX(), e.getY())) continue;
                    SimpleSwingExample.this.selectedEntity = entity;
                }
                if (SimpleSwingExample.this.selectedEntity != null) {
                    SimpleSwingExample.this.mouseDownPoint = e.getPoint();
                    SimpleSwingExample.this.selectedEntityPositionAtMouseDown = new Point((int)SimpleSwingExample.this.selectedEntity.getX(), (int)SimpleSwingExample.this.selectedEntity.getY());
                } else {
                    SimpleSwingExample.this.mouseDownPoint = null;
                    SimpleSwingExample.this.selectedEntityPositionAtMouseDown = null;
                }
                SimpleSwingExample.this.updateGUI();
            }

            public void mouseReleased(MouseEvent e) {
                SimpleSwingExample.this.selectedEntity = null;
                SimpleSwingExample.this.mouseDownPoint = null;
                SimpleSwingExample.this.selectedEntityPositionAtMouseDown = null;
                SimpleSwingExample.this.updateGUI();
            }
        });
        this.mainPanel.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void createGraph(boolean addNonTreeRels) {
        this.entities = new ArrayList();
        this.relationships = new ArrayList();
        this.selectedEntity = null;
        this.createTreeGraph(2, 4, 2, 5, true, true, addNonTreeRels);
        this.placeRandomly();
        this.mainPanel.repaint();
    }

    private void createTreeGraph(int minChildren, int maxChildren, int minLevels, int maxLevels, boolean randomNumChildren, boolean randomLevels, boolean addNonTreeRels) {
        SimpleNode currentParent = this.createSimpleNode(this.getNextID());
        this.entities.add(currentParent);
        this.createTreeGraphRecursive(currentParent, minChildren, maxChildren, minLevels, maxLevels, 1, randomNumChildren, randomLevels, addNonTreeRels);
    }

    private void createTreeGraphRecursive(LayoutEntity currentParentNode, int minChildren, int maxChildren, int minLevel, int maxLevel, int level, boolean randomNumChildren, boolean randomLevels, boolean addNonTreeRels) {
        double zeroToOne;
        if (level > maxLevel) {
            return;
        }
        if (randomLevels && level > minLevel && (zeroToOne = Math.random()) < 0.75) {
            return;
        }
        int numChildren = randomNumChildren ? Math.max(minChildren, (int)(Math.random() * (double)maxChildren + 1.0)) : maxChildren;
        int i = 0;
        while (i < numChildren) {
            SimpleNode newNode = this.createSimpleNode(this.getNextID());
            this.entities.add(newNode);
            if (addNonTreeRels && this.entities.size() % 5 == 0) {
                int index = (int)(Math.random() * (double)this.entities.size());
                SimpleRelationship rel = new SimpleRelationship((LayoutEntity)this.entities.get(index), newNode, false);
                this.relationships.add(rel);
            }
            SimpleRelationship rel = new SimpleRelationship(currentParentNode, newNode, false);
            this.relationships.add(rel);
            this.createTreeGraphRecursive(newNode, minChildren, maxChildren, minLevel, maxLevel, level + 1, randomNumChildren, randomLevels, addNonTreeRels);
            ++i;
        }
    }

    private String getNextID() {
        String id = "" + this.idCount;
        ++this.idCount;
        return id;
    }

    private void placeRandomly() {
        Iterator iter = this.entities.iterator();
        while (iter.hasNext()) {
            SimpleNode simpleNode = (SimpleNode)iter.next();
            double x = Math.random() * 700.0 - 20.0;
            double y = Math.random() * 500.0 - 20.0;
            simpleNode.setLocationInLayout(x, y);
            simpleNode.setSizeInLayout(20.0, 20.0);
        }
    }

    private SimpleNode createSimpleNode(String name) {
        SimpleNode simpleNode = new SimpleNode(name);
        return simpleNode;
    }

    private void updateGUI() {
        ++this.updateGUICount;
        if (this.updateGUICount > 0L) {
            this.mainPanel.paintImmediately(0, 0, this.mainPanel.getWidth(), this.mainPanel.getHeight());
        }
    }

    private static Point2D.Double getEllipseIntersectionPoint(double theta, double ellipseWidth, double ellipseHeight) {
        double nhalfw = ellipseWidth / 2.0;
        double nhalfh = ellipseHeight / 2.0;
        double tanTheta = Math.tan(theta);
        double a = nhalfw;
        double b = nhalfh;
        double x = a * b / Math.sqrt(Math.pow(b, 2.0) + Math.pow(a, 2.0) * Math.pow(tanTheta, 2.0));
        if (theta > 1.5707963267948966 && theta < 4.71238898038469 || theta < -1.5707963267948966 && theta > -4.71238898038469) {
            x = -x;
        }
        double y = tanTheta * x;
        Point2D.Double p = new Point2D.Double(x, y);
        return p;
    }

    public static void main(String[] args) {
        new SimpleSwingExample().start();
    }

    static /* synthetic */ void access$19(SimpleSwingExample simpleSwingExample, LayoutAlgorithm layoutAlgorithm) {
        simpleSwingExample.currentLayoutAlgorithm = layoutAlgorithm;
    }

    private class MainPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private MainPanel() {
        }

        protected void paintChildren(Graphics g) {
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            Iterator iter = SimpleSwingExample.this.entities.iterator();
            while (iter.hasNext()) {
                this.paintEntity((SimpleNode)iter.next(), g);
            }
            iter = SimpleSwingExample.this.relationships.iterator();
            while (iter.hasNext()) {
                this.paintRelationship((LayoutRelationship)iter.next(), g);
            }
        }

        private void paintEntity(SimpleNode entity, Graphics g) {
            boolean isSelected = SimpleSwingExample.this.selectedEntity != null && SimpleSwingExample.this.selectedEntity.equals(entity);
            g.setColor(isSelected ? NODE_SELECTED_COLOR : NODE_NORMAL_COLOR);
            if (SimpleSwingExample.this.currentNodeShape.equals("rectangle")) {
                g.fillRect((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            } else {
                g.fillOval((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            }
            g.setColor(isSelected ? BORDER_SELECTED_COLOR : BORDER_NORMAL_COLOR);
            String name = entity.toString();
            Rectangle2D nameBounds = g.getFontMetrics().getStringBounds(name, g);
            g.drawString(name, (int)(entity.getX() + entity.getWidth() / 2.0 - nameBounds.getWidth() / 2.0), (int)(entity.getY() + entity.getHeight() / 2.0 + nameBounds.getHeight() / 2.0));
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(isSelected ? BORDER_SELECTED_STROKE : BORDER_NORMAL_STROKE);
            }
            if (SimpleSwingExample.this.currentNodeShape.equals("rectangle")) {
                g.drawRect((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            } else {
                g.drawOval((int)entity.getX(), (int)entity.getY(), (int)entity.getWidth(), (int)entity.getHeight());
            }
        }

        private void paintRelationship(LayoutRelationship rel, Graphics g) {
            SimpleNode src = (SimpleNode)rel.getSourceInLayout();
            SimpleNode dest = (SimpleNode)rel.getDestinationInLayout();
            if (((SimpleRelationship)rel).getBendPoints() != null && ((SimpleRelationship)rel).getBendPoints().length > 0) {
                this.drawBendPoints(rel, g);
            } else {
                double srcX = src.getX() + src.getWidth() / 2.0;
                double srcY = src.getY() + src.getHeight() / 2.0;
                double destX = dest.getX() + dest.getWidth() / 2.0;
                double destY = dest.getY() + dest.getHeight() / 2.0;
                double dx = this.getLength(srcX, destX);
                double dy = this.getLength(srcY, destY);
                double theta = Math.atan2(dy, dx);
                this.drawRelationship(src, dest, theta, srcX, srcY, destX, destY, g);
                this.drawArrow(theta, srcX, srcY, dx, dy, g);
            }
        }

        private void drawRelationship(SimpleNode src, SimpleNode dest, double theta, double srcX, double srcY, double destX, double destY, Graphics g) {
            double reverseTheta = theta > 0.0 ? theta - Math.PI : theta + Math.PI;
            Point2D.Double srcIntersectionP = SimpleSwingExample.getEllipseIntersectionPoint(theta, src.getWidth(), src.getHeight());
            Point2D.Double destIntersectionP = SimpleSwingExample.getEllipseIntersectionPoint(reverseTheta, dest.getWidth(), dest.getHeight());
            this.drawRelationship(srcX + srcIntersectionP.getX(), srcY + srcIntersectionP.getY(), destX + destIntersectionP.getX(), destY + destIntersectionP.getY(), g);
        }

        private void drawRelationship(double srcX, double srcY, double destX, double destY, Graphics g) {
            g.setColor(RELATIONSHIP_NORMAL_COLOR);
            g.drawLine((int)srcX, (int)srcY, (int)destX, (int)destY);
        }

        private void drawArrow(double theta, double srcX, double srcY, double dx, double dy, Graphics g) {
            AffineTransform tx = new AffineTransform();
            double arrX = srcX + dx / 2.0;
            double arrY = srcY + dy / 2.0;
            tx.translate(arrX, arrY);
            tx.rotate(theta);
            Shape arrowTx = tx.createTransformedShape(ARROW_SHAPE);
            if (g instanceof Graphics2D) {
                g.setColor(ARROW_HEAD_FILL_COLOR);
                ((Graphics2D)g).fill(arrowTx);
                ((Graphics2D)g).setStroke(ARROW_BORDER_STROKE);
                g.setColor(ARROW_HEAD_BORDER_COLOR);
                ((Graphics2D)g).draw(arrowTx);
            }
        }

        private double getLength(double start, double end) {
            double length = end - start;
            if (length < 0.01 && length > -0.01) {
                if (length > 0.0) {
                    length = 0.01;
                } else if (length < 0.0) {
                    length = -0.01;
                }
            }
            return length;
        }

        private void drawCurvedRelationship(double srcX, double srcY, double control1X, double control1Y, double control2X, double control2Y, double destX, double destY, Graphics g) {
            GeneralPath shape = new GeneralPath();
            shape.moveTo((float)srcX, (float)srcY);
            shape.curveTo((float)control1X, (float)control1Y, (float)control2X, (float)control2Y, (float)destX, (float)destY);
            g.setColor(RELATIONSHIP_NORMAL_COLOR);
            ((Graphics2D)g).draw(shape);
        }

        private void drawBendPoints(LayoutRelationship rel, Graphics g) {
            SimpleNode startEntity = (SimpleNode)rel.getSourceInLayout();
            SimpleNode destEntity = (SimpleNode)rel.getDestinationInLayout();
            double srcX = startEntity.getX();
            double srcY = startEntity.getY();
            LayoutBendPoint[] bendPoints = ((SimpleRelationship)rel).getBendPoints();
            srcX = bendPoints[1].getX();
            srcY = bendPoints[1].getY();
            int bpNum = 2;
            while (bpNum < bendPoints.length - 1) {
                int currentBpNum = bpNum;
                LayoutBendPoint bp = bendPoints[bpNum];
                if (bp.getIsControlPoint()) {
                    if (bendPoints[bpNum + 1].getIsControlPoint()) {
                        destEntity = new SimpleNode("dummy", bendPoints[bpNum + 2].getX(), bendPoints[bpNum + 2].getY(), 0.01, 0.01);
                        this.drawCurvedRelationship(srcX, srcY, bp.getX(), bp.getY(), bendPoints[bpNum + 1].getX(), bendPoints[bpNum + 1].getY(), bendPoints[bpNum + 2].getX(), bendPoints[bpNum + 2].getY(), g);
                        bpNum += 4;
                    } else {
                        destEntity = new SimpleNode("dummy", bp.getX(), bp.getY(), 0.01, 0.01);
                    }
                } else {
                    this.drawRelationship(srcX, srcY, bp.getX(), bp.getY(), g);
                    ++bpNum;
                    destEntity = new SimpleNode("dummy", bp.getX(), bp.getY(), 0.01, 0.01);
                }
                startEntity = destEntity;
                if (currentBpNum == bendPoints.length - 2) {
                    double dx = this.getLength(srcX, destEntity.getX());
                    double dy = this.getLength(srcY, destEntity.getY());
                    double theta = Math.atan2(dy, dx);
                    this.drawArrow(theta, srcX, srcY, dx, dy, g);
                    continue;
                }
                srcX = startEntity.getX();
                srcY = startEntity.getY();
            }
        }
    }
}

