/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.gradle.tooling.internal.gradle.DefaultGradleScript;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleProject<T>
implements Serializable,
GradleProjectIdentity {
    private DefaultGradleScript buildScript = new DefaultGradleScript();
    private File buildDirectory;
    private File projectDirectory;
    private List<T> tasks = new LinkedList<T>();
    private String name;
    private String description;
    private DefaultProjectIdentifier projectIdentifier;
    private DefaultGradleProject<T> parent;
    private List<? extends DefaultGradleProject<T>> children = new LinkedList<DefaultGradleProject<T>>();

    public String getName() {
        return this.name;
    }

    public DefaultGradleProject<T> setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DefaultGradleProject<T> setDescription(String description) {
        this.description = description;
        return this;
    }

    public DefaultGradleProject<T> getParent() {
        return this.parent;
    }

    public DefaultGradleProject<T> setParent(DefaultGradleProject<T> parent) {
        this.parent = parent;
        return this;
    }

    public Collection<? extends DefaultGradleProject<T>> getChildren() {
        return this.children;
    }

    public DefaultGradleProject<T> setChildren(List<? extends DefaultGradleProject<T>> children) {
        this.children = children;
        return this;
    }

    public String getPath() {
        return this.projectIdentifier.getProjectPath();
    }

    public DefaultProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    @Override
    public String getProjectPath() {
        return this.projectIdentifier.getProjectPath();
    }

    @Override
    public File getRootDir() {
        return this.projectIdentifier.getBuildIdentifier().getRootDir();
    }

    public DefaultGradleProject<T> setProjectIdentifier(DefaultProjectIdentifier projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
        return this;
    }

    public DefaultGradleProject<T> findByPath(String path) {
        if (path.equals(this.getPath())) {
            return this;
        }
        for (DefaultGradleProject<T> child : this.children) {
            DefaultGradleProject<T> found = child.findByPath(path);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public String toString() {
        return "GradleProject{path='" + this.getPath() + '\'' + '}';
    }

    public Collection<T> getTasks() {
        return this.tasks;
    }

    public DefaultGradleProject<T> setTasks(List<T> tasks) {
        this.tasks = tasks;
        return this;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public DefaultGradleProject<T> setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
        return this;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public DefaultGradleProject<T> setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
        return this;
    }

    public DefaultGradleScript getBuildScript() {
        return this.buildScript;
    }
}

