/*
 * Decompiled with CFR 0.152.
 */
package com.naef.jnlua.console;

import com.naef.jnlua.LuaException;
import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class LuaConsole {
    private static final String[] EMPTY_ARGS = new String[0];
    private LuaState luaState = new LuaState();

    public static void main(String[] args) {
        LuaConsole luaConsole = new LuaConsole(args);
        luaConsole.run();
        System.exit(0);
    }

    public LuaConsole() {
        this(EMPTY_ARGS);
    }

    public LuaConsole(String[] args) {
        this.luaState.newTable(args.length, 0);
        int i = 0;
        while (i < args.length) {
            this.luaState.pushString(args[i]);
            this.luaState.rawSet(-2, i + 1);
            ++i;
        }
        this.luaState.setGlobal("argv");
        this.luaState.openLibs();
        this.luaState.load("io.stdout:setvbuf(\"no\")", "setvbuf");
        this.luaState.call(0, 0);
        this.luaState.load("io.stderr:setvbuf(\"no\")", "setvbuf");
        this.luaState.call(0, 0);
    }

    public LuaState getLuaState() {
        return this.luaState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        System.out.println(String.format("JNLua %s Console using Lua %s.", "0.9", LuaState.LUA_VERSION));
        System.out.print("Type 'go' on an empty line to evaluate a chunk. ");
        System.out.println("Type =<expression> to print an expression.");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            block2: while (true) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                boolean firstLine = true;
                while (true) {
                    ByteArrayInputStream in;
                    String line;
                    if ((line = bufferedReader.readLine()) == null) {
                        return;
                    }
                    if (line.equals("go")) {
                        outWriter.flush();
                        in = new ByteArrayInputStream(out.toByteArray());
                        this.runChunk(in);
                        continue block2;
                    }
                    if (firstLine && line.startsWith("=")) {
                        outWriter.write("return " + line.substring(1));
                        outWriter.flush();
                        in = new ByteArrayInputStream(out.toByteArray());
                        this.runChunk(in);
                        continue block2;
                    }
                    outWriter.write(line);
                    outWriter.write(10);
                    firstLine = false;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.print("IO error: ");
            System.out.print(e.getMessage());
            System.out.println();
        }
    }

    protected void runChunk(InputStream in) throws IOException {
        try {
            long start = System.nanoTime();
            this.luaState.setTop(0);
            this.luaState.load(in, "console");
            this.luaState.call(0, -1);
            long stop = System.nanoTime();
            int i = 1;
            while (i <= this.luaState.getTop()) {
                if (i > 1) {
                    System.out.print(", ");
                }
                switch (this.luaState.type(i)) {
                    case BOOLEAN: {
                        System.out.print((Object)this.luaState.toBoolean(i));
                        break;
                    }
                    case NUMBER: 
                    case STRING: {
                        System.out.print(this.luaState.toString(i));
                        break;
                    }
                    default: {
                        System.out.print(this.luaState.typeName(i));
                    }
                }
                ++i;
            }
            System.out.print("\t#msec=");
            System.out.print(String.format("%.3f", (double)(stop - start) / 1000000.0));
            System.out.println();
        }
        catch (LuaRuntimeException e) {
            e.printLuaStackTrace();
            e.printStackTrace();
        }
        catch (LuaException e) {
            System.err.println(e.getMessage());
        }
    }
}

