/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.views.provider;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class CrossTabViewNodeProvider
extends DefaultNodeProvider {
    public Object[] getChildren(Object model) {
        ExtendedItemHandle handle = (ExtendedItemHandle)model;
        try {
            CrosstabViewHandle crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
            int dimensionCount = crossTabViewHandle.getDimensionCount();
            ArrayList<DesignElementHandle> list = new ArrayList<DesignElementHandle>();
            int i = 0;
            while (i < dimensionCount) {
                DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
                int levelCount = dimension.getLevelCount();
                int j = 0;
                while (j < levelCount) {
                    list.add(dimension.getLevel(j).getModelHandle());
                    ++j;
                }
                ++i;
            }
            if (crossTabViewHandle.getGrandTotal() != null) {
                list.add(crossTabViewHandle.getGrandTotal().getModelHandle());
            }
            return list.toArray();
        }
        catch (ExtendedElementException extendedElementException) {
            return new Object[0];
        }
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
    }

    public Image getNodeIcon(Object model) {
        ExtendedItemHandle handle = (ExtendedItemHandle)model;
        try {
            CrosstabViewHandle crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
            if (crossTabViewHandle.getAxisType() == 1) {
                return CrosstabUIHelper.getImage("icons/pal/column-area.gif");
            }
            if (crossTabViewHandle.getAxisType() == 0) {
                return CrosstabUIHelper.getImage("icons/pal/row-area.gif");
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        return super.getNodeIcon(model);
    }

    public String getNodeDisplayName(Object model) {
        ExtendedItemHandle handle = (ExtendedItemHandle)model;
        try {
            CrosstabViewHandle crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
            if (crossTabViewHandle.getAxisType() == 1) {
                return Messages.getString("CrossTabViewNodeProvider.ColumnArea");
            }
            if (crossTabViewHandle.getAxisType() == 0) {
                return Messages.getString("CrossTabViewNodeProvider.RowArea");
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        return super.getNodeDisplayName(model);
    }

    public boolean hasChildren(Object model) {
        return this.getChildren(model).length != 0;
    }

    public Object getParent(Object model) {
        ExtendedItemHandle handle = (ExtendedItemHandle)model;
        try {
            CrosstabViewHandle crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
            return crossTabViewHandle.getCrosstab().getModelHandle();
        }
        catch (ExtendedElementException extendedElementException) {
            return null;
        }
    }
}

