/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import java.io.File;
import java.util.Set;
import org.eclipse.buildship.core.UnsupportedConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class ValidateProjectLocationOperation {
    private static final File WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
    private final Set<OmniEclipseProject> projects;

    public ValidateProjectLocationOperation(Set<OmniEclipseProject> projects) {
        this.projects = ImmutableSet.copyOf(projects);
    }

    public void run(IProgressMonitor monitor) {
        for (OmniEclipseProject project : this.projects) {
            if (!project.getProjectDirectory().equals(WORKSPACE_ROOT)) continue;
            throw new UnsupportedConfigurationException(String.format("Project %s location matches workspace root %s", project.getName(), WORKSPACE_ROOT.getAbsolutePath()));
        }
    }
}

