/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.build.gcc.core.ClangToolChain;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.build.gcc.core.internal.Activator;
import org.eclipse.cdt.build.gcc.core.internal.Messages;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.build.IUserToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GCCUserToolChainProvider
implements IUserToolChainProvider {
    public static final String PROVIDER_ID = "org.eclipse.cdt.build.gcc.core.provider.user";
    private static final String ARCH = "arch";
    private static final String DELIMITER = "delimiter";
    private static final String ENVIRONMENT = "environment";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String OPERATION = "operation";
    private static final String PATH = "path";
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private IToolChainManager manager;
    private JsonArray toolChains;

    public String getId() {
        return PROVIDER_ID;
    }

    private File getJsonFile() {
        return Activator.getPlugin().getStateLocation().append("toolchains.json").toFile();
    }

    public void init(IToolChainManager manager) throws CoreException {
        block19: {
            this.manager = manager;
            try {
                File jsonFile = this.getJsonFile();
                if (!jsonFile.exists()) break block19;
                this.toolChains = new JsonParser().parse((Reader)new FileReader(jsonFile)).getAsJsonArray();
                for (JsonElement element : this.toolChains) {
                    JsonObject tc = element.getAsJsonObject();
                    String type = tc.has(TYPE) ? tc.get(TYPE).getAsString() : "org.eclipse.cdt.build.gcc";
                    String arch = tc.has(ARCH) ? tc.get(ARCH).getAsString() : null;
                    Path path = Paths.get(tc.get(PATH).getAsString(), new String[0]);
                    IEnvironmentVariable[] envvars = null;
                    if (tc.has(ENVIRONMENT)) {
                        ArrayList<EnvironmentVariable> envlist = new ArrayList<EnvironmentVariable>();
                        for (JsonElement var : tc.get(ENVIRONMENT).getAsJsonArray()) {
                            JsonObject varobj = var.getAsJsonObject();
                            String name = varobj.get(NAME).getAsString();
                            int operation = varobj.get(OPERATION).getAsInt();
                            String value = null;
                            if (varobj.has(VALUE)) {
                                value = varobj.get(VALUE).getAsString();
                            }
                            String delimiter = null;
                            if (varobj.has(DELIMITER)) {
                                delimiter = varobj.get(DELIMITER).getAsString();
                            }
                            envlist.add(new EnvironmentVariable(name, value, operation, delimiter));
                        }
                        envvars = envlist.toArray(new IEnvironmentVariable[0]);
                    }
                    GCCToolChain gcc = null;
                    switch (type) {
                        case "org.eclipse.cdt.build.gcc": {
                            gcc = new GCCToolChain((IToolChainProvider)this, path, arch, envvars);
                            break;
                        }
                        case "org.eclipse.cdt.build.clang": {
                            gcc = new ClangToolChain((IToolChainProvider)this, path, arch, envvars);
                        }
                    }
                    if (gcc == null) continue;
                    if (tc.has(PROPERTIES)) {
                        for (JsonElement prop : tc.get(PROPERTIES).getAsJsonArray()) {
                            JsonObject propobj = prop.getAsJsonObject();
                            gcc.setProperty(propobj.get(NAME).getAsString(), propobj.get(VALUE).getAsString());
                        }
                    }
                    manager.addToolChain(gcc);
                }
            }
            catch (IOException | IllegalStateException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getId(), Messages.GCCUserToolChainProvider_Loading, (Throwable)e));
            }
        }
    }

    public void addToolChain(IToolChain toolChain) throws CoreException {
        IEnvironmentVariable[] envvars;
        if (!(toolChain instanceof GCCToolChain)) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), Messages.GCCUserToolChainProvider_NotOurs));
        }
        GCCToolChain gcc = (GCCToolChain)toolChain;
        if (this.toolChains == null) {
            this.toolChains = new JsonArray();
        }
        JsonObject newtc = new JsonObject();
        this.toolChains.add((JsonElement)newtc);
        newtc.addProperty(ID, gcc.getId());
        newtc.addProperty(ARCH, gcc.getProperty(ARCH));
        newtc.addProperty(PATH, gcc.getPath().toString());
        Map<String, String> properties = gcc.getProperties();
        if (properties != null && !properties.isEmpty()) {
            JsonArray props = new JsonArray();
            newtc.add(PROPERTIES, (JsonElement)props);
            for (Map.Entry<String, String> entry : gcc.getProperties().entrySet()) {
                JsonObject prop = new JsonObject();
                props.add((JsonElement)prop);
                prop.addProperty(NAME, entry.getKey());
                prop.addProperty(VALUE, entry.getValue());
            }
        }
        if ((envvars = gcc.getVariables()) != null && envvars.length > 0) {
            JsonArray env = new JsonArray();
            newtc.add(ENVIRONMENT, (JsonElement)env);
            IEnvironmentVariable[] iEnvironmentVariableArray = gcc.getVariables();
            int n = iEnvironmentVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                String delimiter;
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                JsonObject envvar = new JsonObject();
                env.add((JsonElement)envvar);
                envvar.addProperty(NAME, var.getName());
                envvar.addProperty(OPERATION, (Number)var.getOperation());
                String value = var.getValue();
                if (value != null) {
                    envvar.addProperty(VALUE, value);
                }
                if ((delimiter = var.getDelimiter()) != null) {
                    envvar.addProperty(DELIMITER, delimiter);
                }
                ++n2;
            }
        }
        try {
            this.saveJsonFile();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), Messages.GCCUserToolChainProvider_Saving, (Throwable)e));
        }
        this.manager.addToolChain(toolChain);
    }

    public void removeToolChain(IToolChain toolChain) throws CoreException {
        if (this.toolChains != null) {
            String id = toolChain.getId();
            JsonArray copy = new JsonArray();
            copy.addAll(this.toolChains);
            for (JsonElement element : copy) {
                JsonObject tc = element.getAsJsonObject();
                if (!id.equals(tc.get(ID).getAsString())) continue;
                this.toolChains.remove(element);
            }
            try {
                this.saveJsonFile();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getId(), Messages.GCCUserToolChainProvider_Saving1, (Throwable)e));
            }
        }
        this.manager.removeToolChain(toolChain);
    }

    private void saveJsonFile() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileWriter writer = new FileWriter(this.getJsonFile());){
            writer.write(new Gson().toJson((JsonElement)this.toolChains));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

