/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.lrparser.ISecondaryParser;
import org.eclipse.cdt.core.dom.lrparser.action.ASTCompletionNode;
import org.eclipse.cdt.core.dom.lrparser.action.AbstractParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.ISecondaryParserFactory;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.action.ParserUtil;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;

public abstract class BuildASTParserAction
extends AbstractParserAction {
    private final INodeFactory nodeFactory;
    private final ISecondaryParserFactory parserFactory;
    protected IASTTranslationUnit tu = null;
    private int initializerListNestingLevel = 0;

    protected abstract boolean isIdentifierToken(IToken var1);

    public BuildASTParserAction(ITokenStream parser, ScopedStack<Object> astStack, INodeFactory nodeFactory, ISecondaryParserFactory parserFactory) {
        super(parser, astStack);
        if (nodeFactory == null) {
            throw new NullPointerException("nodeFactory is null");
        }
        if (parserFactory == null) {
            throw new NullPointerException("parserFactory is null");
        }
        this.nodeFactory = nodeFactory;
        this.parserFactory = parserFactory;
    }

    public void initializeTranslationUnit(IScanner scanner, IBuiltinBindingsProvider builtinBindingsProvider, IIndex index) {
        this.tu = this.nodeFactory.newTranslationUnit(scanner);
        this.tu.setIndex(index);
        if (builtinBindingsProvider != null) {
            IBinding[] bindings;
            IScope tuScope = this.tu.getScope();
            IBinding[] iBindingArray = bindings = builtinBindingsProvider.getBuiltinBindings(tuScope);
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray[n2];
                ASTInternal.addBinding((IScope)tuScope, (IBinding)binding);
                ++n2;
            }
        }
        if (this.tu instanceof ASTTranslationUnit) {
            ((ASTTranslationUnit)this.tu).setLocationResolver(scanner.getLocationResolver());
        }
    }

    public void consumeTranslationUnit() {
        if (this.tu == null) {
            this.tu = this.nodeFactory.newTranslationUnit(null);
        }
        for (Object o : this.astStack.topScope()) {
            this.tu.addDeclaration((IASTDeclaration)o);
        }
        while (!this.astStack.isEmpty()) {
            this.astStack.pop();
        }
        IASTDeclaration[] declarations = this.tu.getDeclarations();
        if (declarations.length != 0) {
            IASTDeclaration d = declarations[declarations.length - 1];
            ParserUtil.setOffsetAndLength((IASTNode)this.tu, 0, ParserUtil.offset((IASTNode)d) + ParserUtil.length((IASTNode)d));
        }
        BuildASTParserAction.resolveAmbiguityNodes(this.tu);
        this.tu.freeze();
        this.astStack.push(this.tu);
    }

    @Override
    public ASTCompletionNode newCompletionNode(String prefix) {
        return new ASTCompletionNode(prefix, this.tu);
    }

    private static void resolveAmbiguityNodes(IASTTranslationUnit tu) {
        if (tu instanceof ASTTranslationUnit) {
            ((ASTTranslationUnit)tu).resolveAmbiguities();
        }
    }

    public void consumeIdentifierName() {
        this.astStack.push(this.createName(this.stream.getRightIToken()));
    }

    public void consumeStatementDeclarationWithDisambiguation() {
        IASTDeclarationStatement result;
        IASTDeclaration decl = (IASTDeclaration)this.astStack.pop();
        IASTDeclarationStatement declarationStatement = this.nodeFactory.newDeclarationStatement(decl);
        this.setOffsetAndLength((IASTNode)declarationStatement);
        IASTExpressionStatement expressionStatement = null;
        if (decl instanceof IASTSimpleDeclaration) {
            List<IToken> expressionTokens = this.stream.getRuleTokens();
            expressionTokens = expressionTokens.subList(0, expressionTokens.size() - 1);
            ISecondaryParser<IASTExpression> expressionParser = this.parserFactory.getExpressionParser(this.stream, this.properties);
            IASTExpression expr = this.runSecondaryParser(expressionParser, expressionTokens);
            if (expr != null) {
                expressionStatement = this.nodeFactory.newExpressionStatement(expr);
                this.setOffsetAndLength((IASTNode)expressionStatement);
            }
        }
        List<IToken> tokens = this.stream.getRuleTokens();
        if (expressionStatement == null) {
            result = declarationStatement;
        } else if (expressionStatement.getExpression() instanceof IASTFunctionCallExpression) {
            result = expressionStatement;
        } else if (tokens.size() == 2 && (this.isCompletionToken(tokens.get(0)) || this.isIdentifierToken(tokens.get(0)))) {
            result = expressionStatement;
        } else if (BuildASTParserAction.isImplicitInt(decl)) {
            result = expressionStatement;
        } else {
            result = this.createAmbiguousStatement(new IASTStatement[]{declarationStatement, expressionStatement});
            this.setOffsetAndLength((IASTNode)result);
        }
        this.astStack.push(result);
    }

    protected abstract IASTAmbiguousStatement createAmbiguousStatement(IASTStatement ... var1);

    public void consumeStatementDeclaration() {
        IASTDeclaration decl = (IASTDeclaration)this.astStack.pop();
        IASTDeclarationStatement declarationStatement = this.nodeFactory.newDeclarationStatement(decl);
        this.setOffsetAndLength((IASTNode)declarationStatement);
        this.astStack.push(declarationStatement);
    }

    protected static boolean isImplicitInt(IASTDeclaration declaration) {
        IASTDeclSpecifier declSpec;
        return declaration instanceof IASTSimpleDeclaration && (declSpec = ((IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)declSpec).getType() == 0;
    }

    public void consumeExpressionLiteral(int kind) {
        IToken token = this.stream.getRightIToken();
        String rep = token.toString();
        IASTLiteralExpression expr = this.nodeFactory.newLiteralExpression(kind, rep);
        ParserUtil.setOffsetAndLength((IASTNode)expr, token);
        this.astStack.push(expr);
    }

    public void consumeExpressionBracketed() {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTUnaryExpression expr = this.nodeFactory.newUnaryExpression(11, operand);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionID() {
        IASTName name = this.createName(this.stream.getLeftIToken());
        IASTIdExpression expr = this.nodeFactory.newIdExpression(name);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionName() {
        IASTName name = (IASTName)this.astStack.pop();
        IASTIdExpression expr = this.nodeFactory.newIdExpression(name);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionList() {
        List expressions = this.astStack.closeScope();
        if (expressions.size() == 1) {
            this.astStack.push(expressions.get(0));
        } else {
            IASTExpressionList exprList = this.nodeFactory.newExpressionList();
            for (Object o : expressions) {
                exprList.addExpression((IASTExpression)o);
            }
            this.setOffsetAndLength((IASTNode)exprList);
            this.astStack.push(exprList);
        }
    }

    public void consumeExpressionArraySubscript() {
        IASTExpression subscript = (IASTExpression)this.astStack.pop();
        IASTExpression arrayExpr = (IASTExpression)this.astStack.pop();
        IASTArraySubscriptExpression expr = this.nodeFactory.newArraySubscriptExpression(arrayExpr, subscript);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionFunctionCall() {
        IASTExpression argList = (IASTExpression)this.astStack.pop();
        IASTExpression idExpr = (IASTExpression)this.astStack.pop();
        IASTFunctionCallExpression expr = this.nodeFactory.newFunctionCallExpression(idExpr, argList);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionCast(int operator) {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        IASTCastExpression expr = this.nodeFactory.newCastExpression(operator, typeId, operand);
        this.setOffsetAndLength((IASTNode)expr);
        IASTExpression alternateExpr = null;
        if (operator == 0) {
            ISecondaryParser<IASTExpression> secondaryParser = this.parserFactory.getNoCastExpressionParser(this.stream, this.properties);
            alternateExpr = this.runSecondaryParser(secondaryParser);
        }
        if (alternateExpr == null) {
            this.astStack.push(expr);
        } else {
            IASTAmbiguousExpression ambiguityNode = this.createAmbiguousExpression(new IASTExpression[]{expr, alternateExpr});
            this.setOffsetAndLength((IASTNode)ambiguityNode);
            this.astStack.push(ambiguityNode);
        }
    }

    protected abstract IASTAmbiguousExpression createAmbiguousExpression(IASTExpression ... var1);

    public void consumeExpressionUnaryOperator(int operator) {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTUnaryExpression expr = this.nodeFactory.newUnaryExpression(operator, operand);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionTypeId(int operator) {
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        IASTTypeIdExpression expr = this.nodeFactory.newTypeIdExpression(operator, typeId);
        this.setOffsetAndLength((IASTNode)expr);
        ISecondaryParser<IASTExpression> secondaryParser = this.parserFactory.getSizeofExpressionParser(this.stream, this.properties);
        IASTExpression alternateExpr = this.runSecondaryParser(secondaryParser);
        if (alternateExpr == null) {
            this.astStack.push(expr);
        } else if (BuildASTParserAction.isFunctionType((IASTExpression)expr)) {
            this.astStack.push(alternateExpr);
        } else {
            IASTAmbiguousExpression ambiguityNode = this.createAmbiguousExpression(new IASTExpression[]{expr, alternateExpr});
            this.setOffsetAndLength((IASTNode)ambiguityNode);
            this.astStack.push(ambiguityNode);
        }
    }

    private static boolean isFunctionType(IASTExpression expr) {
        if (expr instanceof IASTTypeIdExpression) {
            IASTTypeId typeId = ((IASTTypeIdExpression)expr).getTypeId();
            return typeId.getAbstractDeclarator() instanceof IASTFunctionDeclarator;
        }
        return false;
    }

    public void consumeExpressionBinaryOperator(int op) {
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTExpression expr1 = (IASTExpression)this.astStack.pop();
        IASTBinaryExpression binExpr = this.nodeFactory.newBinaryExpression(op, expr1, expr2);
        this.setOffsetAndLength((IASTNode)binExpr);
        this.astStack.push(binExpr);
    }

    public void consumeExpressionConditional() {
        IASTExpression expr3 = (IASTExpression)this.astStack.pop();
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTExpression expr1 = (IASTExpression)this.astStack.pop();
        IASTConditionalExpression condExpr = this.nodeFactory.newConditionalExpession(expr1, expr2, expr3);
        this.setOffsetAndLength((IASTNode)condExpr);
        this.astStack.push(condExpr);
    }

    public void consumeStatementLabeled() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTName label = this.createName(this.stream.getLeftIToken());
        IASTLabelStatement stat = this.nodeFactory.newLabelStatement(label, body);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementCase() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTCaseStatement caseStatement = this.nodeFactory.newCaseStatement(expr);
        this.setOffsetAndLength((IASTNode)caseStatement);
        IASTCompoundStatement compound = this.nodeFactory.newCompoundStatement();
        this.setOffsetAndLength((IASTNode)compound);
        compound.addStatement((IASTStatement)caseStatement);
        compound.addStatement(body);
        this.astStack.push(compound);
    }

    public void consumeStatementDefault() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTDefaultStatement stat = this.nodeFactory.newDefaultStatement();
        List<IToken> tokens = this.stream.getRuleTokens();
        IToken defaultToken = tokens.get(0);
        IToken colonToken = tokens.get(1);
        ParserUtil.setOffsetAndLength((IASTNode)stat, ParserUtil.offset(defaultToken), ParserUtil.offset(colonToken) - ParserUtil.offset(defaultToken) + 1);
        IASTCompoundStatement compound = this.nodeFactory.newCompoundStatement();
        this.setOffsetAndLength((IASTNode)compound);
        compound.addStatement((IASTStatement)stat);
        compound.addStatement(body);
        this.astStack.push(compound);
    }

    public void consumeStatementNull() {
        IASTNullStatement stat = this.nodeFactory.newNullStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementExpression() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTExpressionStatement stat = this.nodeFactory.newExpressionStatement(expr);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementCompoundStatement(boolean hasStatementsInBody) {
        IASTCompoundStatement block = this.nodeFactory.newCompoundStatement();
        if (hasStatementsInBody) {
            for (Object o : this.astStack.closeScope()) {
                block.addStatement((IASTStatement)o);
            }
        }
        this.setOffsetAndLength((IASTNode)block);
        this.astStack.push(block);
    }

    public void consumeStatementDoLoop(boolean hasWhileBlock) {
        IASTExpression condition = hasWhileBlock ? (IASTExpression)this.astStack.pop() : null;
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTDoStatement stat = this.nodeFactory.newDoStatement(body, condition);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementGoto() {
        IASTName name = this.createName(this.stream.getRuleTokens().get(1));
        IASTGotoStatement gotoStat = this.nodeFactory.newGotoStatement(name);
        this.setOffsetAndLength((IASTNode)gotoStat);
        this.astStack.push(gotoStat);
    }

    public void consumeStatementContinue() {
        IASTContinueStatement stat = this.nodeFactory.newContinueStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementBreak() {
        IASTBreakStatement stat = this.nodeFactory.newBreakStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementReturn(boolean hasExpr) {
        IASTExpression expr = hasExpr ? (IASTExpression)this.astStack.pop() : null;
        IASTReturnStatement returnStat = this.nodeFactory.newReturnStatement(expr);
        this.setOffsetAndLength((IASTNode)returnStat);
        this.astStack.push(returnStat);
    }

    public void consumeTypeId(boolean hasDeclarator) {
        IASTDeclarator declarator;
        if (hasDeclarator) {
            declarator = (IASTDeclarator)this.astStack.pop();
        } else {
            declarator = this.nodeFactory.newDeclarator(this.nodeFactory.newName());
            ParserUtil.setOffsetAndLength((IASTNode)declarator, this.stream.getRightIToken().getEndOffset(), 0);
        }
        IASTDeclSpecifier declSpecifier = (IASTDeclSpecifier)this.astStack.pop();
        IASTTypeId typeId = this.nodeFactory.newTypeId(declSpecifier, declarator);
        this.setOffsetAndLength((IASTNode)typeId);
        this.astStack.push(typeId);
    }

    public void consumeDeclaratorWithPointer(boolean hasDeclarator) {
        IASTDeclarator decl = hasDeclarator ? (IASTDeclarator)this.astStack.pop() : this.nodeFactory.newDeclarator(this.nodeFactory.newName());
        for (Object pointer : this.astStack.closeScope()) {
            decl.addPointerOperator((IASTPointerOperator)pointer);
        }
        this.setOffsetAndLength((IASTNode)decl);
        this.astStack.push(decl);
    }

    public void consumeDeclaratorWithInitializer(boolean hasDeclarator) {
        IASTDeclarator declarator;
        IASTInitializer initializer = (IASTInitializer)this.astStack.pop();
        if (hasDeclarator) {
            declarator = (IASTDeclarator)this.astStack.peek();
        } else {
            IASTName emptyName = this.nodeFactory.newName();
            declarator = this.nodeFactory.newDeclarator(emptyName);
            this.setOffsetAndLength((IASTNode)emptyName);
            this.astStack.push(declarator);
        }
        declarator.setInitializer(initializer);
        this.setOffsetAndLength((IASTNode)declarator);
    }

    public void consumeDeclarationASM() {
        String s = this.stream.getRuleTokens().get(2).toString();
        IASTASMDeclaration asm = this.nodeFactory.newASMDeclaration(s);
        this.setOffsetAndLength((IASTNode)asm);
        this.astStack.push(asm);
    }

    public void consumeParameterDeclaration() {
        IASTDeclarator declarator = (IASTDeclarator)this.astStack.pop();
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)this.astStack.pop();
        IASTParameterDeclaration declaration = this.nodeFactory.newParameterDeclaration(declSpec, declarator);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeParameterDeclarationWithoutDeclarator() {
        int endOffset = this.stream.getRightIToken().getEndOffset();
        IASTName name = this.nodeFactory.newName();
        ParserUtil.setOffsetAndLength((IASTNode)name, endOffset, 0);
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(name);
        ParserUtil.setOffsetAndLength((IASTNode)declarator, endOffset, 0);
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)this.astStack.pop();
        IASTParameterDeclaration declaration = this.nodeFactory.newParameterDeclaration(declSpec, declarator);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeDirectDeclaratorBracketed() {
        IASTDeclarator nested = (IASTDeclarator)this.astStack.pop();
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(this.nodeFactory.newName());
        declarator.setNestedDeclarator(nested);
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeDirectDeclaratorIdentifier() {
        IASTName name = (IASTName)this.astStack.pop();
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(name);
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeDirectDeclaratorArrayModifier(boolean hasAssignmentExpr) {
        IASTExpression expr = hasAssignmentExpr ? (IASTExpression)this.astStack.pop() : null;
        IASTArrayModifier arrayModifier = this.nodeFactory.newArrayModifier(expr);
        this.setOffsetAndLength((IASTNode)arrayModifier);
        this.astStack.push(arrayModifier);
    }

    protected void addArrayModifier(IASTArrayModifier arrayModifier) {
        IASTDeclarator node = (IASTDeclarator)this.astStack.pop();
        if (node.getNestedDeclarator() != null) {
            IASTArrayDeclarator declarator = this.nodeFactory.newArrayDeclarator(this.nodeFactory.newName());
            IASTDeclarator nested = node;
            declarator.setNestedDeclarator(nested);
            int offset = ParserUtil.offset((IASTNode)nested);
            int length = ParserUtil.endOffset((IASTNode)arrayModifier) - offset;
            ParserUtil.setOffsetAndLength((IASTNode)declarator, offset, length);
            declarator.addArrayModifier(arrayModifier);
            this.astStack.push(declarator);
        } else if (node instanceof IASTArrayDeclarator) {
            IASTArrayDeclarator decl = (IASTArrayDeclarator)node;
            ((ASTNode)decl).setLength(ParserUtil.endOffset((IASTNode)arrayModifier) - ParserUtil.offset((IASTNode)decl));
            decl.addArrayModifier(arrayModifier);
            this.astStack.push(decl);
        } else {
            IASTName name = node.getName();
            IASTArrayDeclarator decl = this.nodeFactory.newArrayDeclarator(name);
            int offset = ParserUtil.offset((IASTNode)name);
            int length = ParserUtil.endOffset((IASTNode)arrayModifier) - offset;
            ParserUtil.setOffsetAndLength((IASTNode)decl, offset, length);
            decl.addArrayModifier(arrayModifier);
            this.astStack.push(decl);
        }
    }

    protected void addFunctionModifier(IASTFunctionDeclarator declarator, int endOffset) {
        IASTDeclarator decl = (IASTDeclarator)this.astStack.pop();
        if (decl.getNestedDeclarator() != null) {
            decl = decl.getNestedDeclarator();
            declarator.setNestedDeclarator(decl);
            declarator.setName(this.nodeFactory.newName());
            int offset = ParserUtil.offset((IASTNode)decl);
            ParserUtil.setOffsetAndLength((IASTNode)declarator, offset, endOffset - offset);
            this.astStack.push(declarator);
        } else {
            IASTPointerOperator[] pointers;
            IASTName name = decl.getName();
            if (name == null) {
                name = this.nodeFactory.newName();
            }
            declarator.setName(name);
            IASTPointerOperator[] iASTPointerOperatorArray = pointers = decl.getPointerOperators();
            int n = pointers.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
                declarator.addPointerOperator(pointer);
                ++n2;
            }
            int offset = ParserUtil.offset((IASTNode)name);
            ParserUtil.setOffsetAndLength((IASTNode)declarator, offset, endOffset - offset);
            this.astStack.push(declarator);
        }
    }

    public void consumeDirectDeclaratorArrayDeclarator(boolean hasDeclarator) {
        IASTArrayModifier arrayModifier = (IASTArrayModifier)this.astStack.pop();
        if (hasDeclarator) {
            this.addArrayModifier(arrayModifier);
        } else {
            IASTArrayDeclarator decl = this.nodeFactory.newArrayDeclarator(this.nodeFactory.newName());
            decl.addArrayModifier(arrayModifier);
            this.setOffsetAndLength((IASTNode)decl);
            this.astStack.push(decl);
        }
    }

    public void consumeTypeSpecifierEnumeration(boolean hasIdent) {
        IASTName name = hasIdent ? this.createName(this.stream.getRuleTokens().get(1)) : this.nodeFactory.newName();
        IASTEnumerationSpecifier enumSpec = this.nodeFactory.newEnumerationSpecifier(name);
        for (Object o : this.astStack.closeScope()) {
            enumSpec.addEnumerator((IASTEnumerationSpecifier.IASTEnumerator)o);
        }
        this.setOffsetAndLength((IASTNode)enumSpec);
        this.astStack.push(enumSpec);
    }

    public void consumeEnumerator(boolean hasInitializer) {
        IASTName name = this.createName(this.stream.getLeftIToken());
        IASTExpression value = null;
        if (hasInitializer) {
            value = (IASTExpression)this.astStack.pop();
        }
        IASTEnumerationSpecifier.IASTEnumerator enumerator = this.nodeFactory.newEnumerator(name, value);
        this.setOffsetAndLength((IASTNode)enumerator);
        this.astStack.push(enumerator);
    }

    public void initializerListStart() {
        ++this.initializerListNestingLevel;
    }

    public void initializerListEnd() {
        --this.initializerListNestingLevel;
    }

    public void consumeInitializer() {
        IASTInitializerClause initClause = (IASTInitializerClause)this.astStack.pop();
        if (initClause instanceof IASTExpression && this.discardInitializer((IASTExpression)initClause)) {
            this.astStack.push(null);
            return;
        }
        IASTEqualsInitializer initializer = this.nodeFactory.newEqualsInitializer(initClause);
        this.setOffsetAndLength((IASTNode)initializer);
        this.astStack.push(initializer);
    }

    private boolean discardInitializer(IASTExpression expression) {
        return this.initializerListNestingLevel > 0 && Boolean.parseBoolean((String)this.properties.get("org.eclipse.cdt.core.dom.lrparser.skipTrivialExpressionsInAggregateInitializers")) && !ASTQueries.canContainName((IASTNode)expression);
    }

    public void consumeInitializerList() {
        IASTInitializerList list = this.nodeFactory.newInitializerList();
        for (Object o : this.astStack.closeScope()) {
            list.addInitializer((IASTInitializer)o);
        }
        this.setOffsetAndLength((IASTNode)list);
        this.astStack.push(list);
    }

    public void consumeBitField(boolean hasDeclarator) {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTName name = hasDeclarator ? ((IASTDeclarator)this.astStack.pop()).getName() : this.nodeFactory.newName();
        IASTFieldDeclarator fieldDecl = this.nodeFactory.newFieldDeclarator(name, expr);
        this.setOffsetAndLength((IASTNode)fieldDecl);
        this.astStack.push(fieldDecl);
    }

    public void consumeStatementProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemStatement(null));
    }

    public void consumeExpressionProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemExpression(null));
    }

    public void consumeDeclarationProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemDeclaration(null));
    }

    private void consumeProblem(IASTProblemHolder problemHolder) {
        IASTProblem problem = this.nodeFactory.newProblem(0x4000001, new char[0], true);
        problemHolder.setProblem(problem);
        this.setOffsetAndLength((IASTNode)problem);
        this.setOffsetAndLength((IASTNode)((ASTNode)problemHolder));
        this.astStack.push(problemHolder);
    }
}

