/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import org.eclipse.dltk.dbgp.internal.packets.DbgpPacket;
import org.eclipse.dltk.dbgp.internal.packets.Messages;
import org.w3c.dom.Element;

public class DbgpStreamPacket
extends DbgpPacket {
    private static final String STDERR = "stderr";
    private static final String STDOUT = "stdout";
    private final String type;
    private final String textContent;

    public DbgpStreamPacket(String type, String textContent, Element content) {
        super(content);
        if (!STDERR.equalsIgnoreCase(type) && !STDOUT.equalsIgnoreCase(type)) {
            throw new IllegalArgumentException(Messages.DbgpStreamPacket_invalidTypeValue);
        }
        if (textContent == null) {
            throw new IllegalArgumentException(Messages.DbgpStreamPacket_contentCannotBeNull);
        }
        this.type = type;
        this.textContent = textContent;
    }

    public boolean isStdout() {
        return STDOUT.equalsIgnoreCase(this.type);
    }

    public boolean isStderr() {
        return STDERR.equalsIgnoreCase(this.type);
    }

    public String getTextContent() {
        return this.textContent;
    }

    public String toString() {
        return "DbgpStreamPacket (Type: " + this.type + "; Content: " + this.textContent + ";)";
    }
}

