/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyForStatement2;
import org.eclipse.dltk.ruby.ast.RubyMethodArgument;
import org.eclipse.dltk.ruby.ast.RubySuperExpression;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.core.codeassist.RubySelectionParser;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyModelUtils;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ruby.typeinference.evaluators.ColonExpressionEvaluator;
import org.eclipse.dltk.ruby.typeinference.evaluators.ConstantReferenceEvaluator;
import org.eclipse.dltk.ruby.typeinference.goals.NonTypeConstantTypeGoal;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class RubySelectionEngine
extends ScriptSelectionEngine {
    public static final boolean DEBUG = DLTKCore.DEBUG_SELECTION;
    protected int actualSelectionStart;
    protected int actualSelectionEnd;
    private Set<IModelElement> selectionElements = new HashSet<IModelElement>();
    private RubySelectionParser parser = new RubySelectionParser();
    private ISourceModule sourceModule;
    private ASTNode[] wayToNode;
    private DLTKTypeInferenceEngine inferencer = new DLTKTypeInferenceEngine();
    private RubyMixinModel mixinModel;

    private TypeDeclaration getEnclosingType(ASTNode node) {
        return ASTUtils.getEnclosingType(this.wayToNode, node, true);
    }

    private CallExpression getEnclosingCallNode(ASTNode node) {
        return ASTUtils.getEnclosingCallNode(this.wayToNode, node, true);
    }

    public IModelElement[] select(IModuleSource sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        this.sourceModule = (ISourceModule)sourceUnit.getModelElement();
        this.mixinModel = RubyMixinModel.getInstance(this.sourceModule.getScriptProject());
        String source = sourceUnit.getSourceContents();
        if (DEBUG) {
            System.out.print("SELECTION IN ");
            System.out.print(sourceUnit.getFileName());
            System.out.print(" FROM ");
            System.out.print(selectionSourceStart);
            System.out.print(" TO ");
            System.out.println(selectionSourceEnd);
            System.out.println("SELECTION - Source :");
            System.out.println(source);
        }
        if (!this.checkSelection(source, selectionSourceStart, selectionSourceEnd)) {
            return new IModelElement[0];
        }
        --this.actualSelectionEnd;
        if (DEBUG) {
            System.out.print("SELECTION - Checked : \"");
            System.out.print(source.substring(this.actualSelectionStart, this.actualSelectionEnd + 1));
            System.out.println('\"');
        }
        try {
            ModuleDeclaration parsedUnit = this.parser.parse(sourceUnit);
            if (parsedUnit != null) {
                ASTNode node;
                if (DEBUG) {
                    System.out.println("SELECTION - AST :");
                    System.out.println(parsedUnit.toString());
                }
                if ((node = ASTUtils.findMinimalNode(parsedUnit, this.actualSelectionStart, this.actualSelectionEnd)) == null) {
                    return new IModelElement[0];
                }
                this.wayToNode = ASTUtils.restoreWayToNode(parsedUnit, node);
                if (node instanceof TypeDeclaration) {
                    this.selectionOnTypeDeclaration(parsedUnit, (TypeDeclaration)node);
                } else if (node instanceof MethodDeclaration) {
                    this.selectionOnMethodDeclaration(parsedUnit, (MethodDeclaration)node);
                } else if (node instanceof ConstantReference || node instanceof RubyColonExpression) {
                    this.selectTypes(parsedUnit, node);
                } else if (node instanceof VariableReference) {
                    this.selectionOnVariable(parsedUnit, (VariableReference)node);
                } else if (node instanceof RubyMethodArgument) {
                    this.selectOnMethodArgument(parsedUnit, (RubyMethodArgument)node);
                } else if (node instanceof RubySuperExpression) {
                    this.selectOnSuper(parsedUnit, (RubySuperExpression)node);
                } else {
                    CallExpression parentCall = this.getEnclosingCallNode(node);
                    if (parentCall != null) {
                        this.selectOnMethod(parsedUnit, parentCall);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            RubyPlugin.log(e);
        }
        return this.selectionElements.toArray(new IModelElement[this.selectionElements.size()]);
    }

    private void selectOnSuper(ModuleDeclaration parsedUnit, RubySuperExpression superExpr) {
        RubyClassType selfClass = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, this.sourceModule, parsedUnit, superExpr.sourceStart());
        MethodDeclaration enclosingMethod = ASTUtils.getEnclosingMethod(this.wayToNode, superExpr, false);
        if (enclosingMethod != null) {
            String name = enclosingMethod.getName();
            RubyMixinClass rubyClass = this.mixinModel.createRubyClass(selfClass);
            RubyMixinClass superclass = rubyClass.getSuperclass();
            RubyMixinMethod method = superclass.getMethod(name);
            if (method != null) {
                IMethod[] sourceMethods = method.getSourceMethods();
                RubySelectionEngine.addArrayToCollection((IMember[])sourceMethods, this.selectionElements);
            }
        }
    }

    private void selectOnColonExpression(ModuleDeclaration parsedUnit, RubyColonExpression node) {
        BasicContext basicContext = new BasicContext(this.sourceModule, parsedUnit);
        ColonExpressionEvaluator evaluator = new ColonExpressionEvaluator((IGoal)new ExpressionTypeGoal((IContext)basicContext, (ASTNode)node));
        IGoal[] init = evaluator.init();
        if (init != null && init.length != 0) {
            IEvaluatedType leftType = this.inferencer.evaluateType((AbstractTypeGoal)init[0], -1);
            IGoal[] goals = evaluator.subGoalDone(init[0], leftType, GoalState.DONE);
            if (goals == null || goals.length == 0) {
                RubyMixinClass mixinClass;
                Object evaluatedType = evaluator.produceResult();
                if (evaluatedType instanceof RubyClassType && (mixinClass = this.mixinModel.createRubyClass((RubyClassType)((Object)evaluatedType))) != null) {
                    RubySelectionEngine.addArrayToCollection((IMember[])mixinClass.getSourceTypes(), this.selectionElements);
                }
            } else if (goals[0] instanceof NonTypeConstantTypeGoal) {
                this.processNonTypeConstant((NonTypeConstantTypeGoal)goals[0]);
            }
        }
    }

    private void processNonTypeConstant(NonTypeConstantTypeGoal ngoal) {
        IMixinElement element = ngoal.getElement();
        if (element != null) {
            Object[] eObjects = element.getAllObjects();
            int i = 0;
            while (i < eObjects.length) {
                RubyMixinElementInfo info;
                Object obj;
                if (eObjects[i] instanceof RubyMixinElementInfo && (obj = (info = (RubyMixinElementInfo)eObjects[i]).getObject()) instanceof IModelElement) {
                    this.selectionElements.add((IModelElement)obj);
                }
                ++i;
            }
        }
    }

    private void selectOnConstant(ModuleDeclaration parsedUnit, ConstantReference node) {
        BasicContext basicContext = new BasicContext(this.sourceModule, parsedUnit);
        ConstantReferenceEvaluator evaluator = new ConstantReferenceEvaluator((IGoal)new ExpressionTypeGoal((IContext)basicContext, (ASTNode)node));
        IGoal[] init = evaluator.init();
        if (init == null || init.length == 0) {
            RubyMixinClass mixinClass;
            Object evaluatedType = evaluator.produceResult();
            if (evaluatedType instanceof RubyClassType && (mixinClass = this.mixinModel.createRubyClass((RubyClassType)((Object)evaluatedType))) != null) {
                RubySelectionEngine.addArrayToCollection((IMember[])mixinClass.getSourceTypes(), this.selectionElements);
            }
        } else if (init[0] instanceof NonTypeConstantTypeGoal) {
            this.processNonTypeConstant((NonTypeConstantTypeGoal)init[0]);
        }
    }

    protected boolean checkSelection(String source, int start, int end) {
        String str;
        if (start > end) {
            int x = start;
            start = end;
            end = x;
        }
        if (start + 1 == end) {
            ISourceRange range = RubySyntaxUtils.getEnclosingName(source, end);
            if (range != null) {
                this.actualSelectionStart = range.getOffset();
                this.actualSelectionEnd = this.actualSelectionStart + range.getLength();
            }
            ISourceRange range2 = RubySyntaxUtils.insideMethodOperator(source, end);
            if (range != null && (range2 == null || range2.getLength() < range.getLength())) {
                return true;
            }
            if (range2 != null) {
                this.actualSelectionStart = range2.getOffset();
                this.actualSelectionEnd = this.actualSelectionStart + range2.getLength();
                return true;
            }
        } else if (start >= 0 && end < source.length() && RubySyntaxUtils.isRubyName(str = source.substring(start, end + 1))) {
            this.actualSelectionStart = start;
            this.actualSelectionEnd = end + 1;
            return true;
        }
        return false;
    }

    private void selectTypes(ModuleDeclaration parsedUnit, ASTNode node) {
        if (node instanceof ConstantReference) {
            this.selectOnConstant(parsedUnit, (ConstantReference)node);
        } else if (node instanceof RubyColonExpression) {
            this.selectOnColonExpression(parsedUnit, (RubyColonExpression)node);
        }
        if (this.selectionElements.isEmpty()) {
            TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    RubySelectionEngine.this.selectionElements.add(match.getType());
                }
            };
            String unqualifiedName = null;
            if (node instanceof RubyColonExpression) {
                RubyColonExpression expr = (RubyColonExpression)node;
                unqualifiedName = expr.getName();
            } else if (node instanceof ConstantReference) {
                ConstantReference expr = (ConstantReference)node;
                unqualifiedName = expr.getName();
            }
            if (unqualifiedName != null) {
                ScriptModelUtil.searchTypeDeclarations((IScriptProject)this.sourceModule.getScriptProject(), (String)unqualifiedName, (TypeNameMatchRequestor)requestor);
            }
        }
    }

    private void selectOnMethodArgument(ModuleDeclaration parsedUnit, RubyMethodArgument arg) {
        this.selectionElements.add((IModelElement)this.createLocalVariable(arg.getName(), arg.sourceStart(), arg.sourceEnd()));
    }

    private void selectionOnVariable(ModuleDeclaration parsedUnit, VariableReference e) {
        String name = e.getName();
        if (name.startsWith("@")) {
            IField[] fields = RubyModelUtils.findFields(this.mixinModel, this.sourceModule, parsedUnit, name, e.sourceStart());
            RubySelectionEngine.addArrayToCollection((IMember[])fields, this.selectionElements);
        } else {
            ASTNode parentScope = null;
            int i = this.wayToNode.length;
            while (--i >= 0) {
                ASTNode node = this.wayToNode[i];
                if (!(node instanceof MethodDeclaration) && !(node instanceof TypeDeclaration) && !(node instanceof ModuleDeclaration) && !(node instanceof RubyForStatement2)) continue;
                parentScope = node;
                break;
            }
            if (parentScope != null) {
                RubyAssignment[] assignments = RubyTypeInferencingUtils.findLocalVariableAssignments(parentScope, (ASTNode)e, name);
                if (assignments.length > 0) {
                    ASTNode left = assignments[0].getLeft();
                    this.selectionElements.add((IModelElement)this.createLocalVariable(name, left.sourceStart(), left.sourceEnd()));
                } else {
                    this.selectionElements.add((IModelElement)this.createLocalVariable(name, e.sourceStart(), e.sourceEnd()));
                }
            }
        }
    }

    private IField createLocalVariable(String name, int nameStart, int nameEnd) {
        return new FakeField(this.sourceModule, name, nameStart, nameEnd - nameStart);
    }

    private IType[] getSourceTypesForClass(ModuleDeclaration parsedUnit, ASTNode statement) {
        RubyMixinClass mixinClass;
        ExpressionTypeGoal typeGoal = new ExpressionTypeGoal((IContext)new BasicContext(this.sourceModule, parsedUnit), statement);
        IEvaluatedType evaluatedType = this.inferencer.evaluateType((AbstractTypeGoal)typeGoal, 5000);
        if (evaluatedType instanceof RubyClassType && (mixinClass = this.mixinModel.createRubyClass((RubyClassType)evaluatedType)) != null) {
            return mixinClass.getSourceTypes();
        }
        return new IType[0];
    }

    private void selectionOnTypeDeclaration(ModuleDeclaration parsedUnit, TypeDeclaration typeDeclaration) {
        IModelElement elementAt = null;
        try {
            elementAt = this.sourceModule.getElementAt(typeDeclaration.sourceStart() + 1);
        }
        catch (ModelException e) {
            RubyPlugin.log((Exception)((Object)e));
        }
        if (elementAt != null) {
            this.selectionElements.add(elementAt);
        }
    }

    private void selectionOnMethodDeclaration(ModuleDeclaration parsedUnit, MethodDeclaration methodDeclaration) {
        IModelElement elementAt = null;
        try {
            elementAt = this.sourceModule.getElementAt(methodDeclaration.sourceStart() + 1);
        }
        catch (ModelException e) {
            RubyPlugin.log((Exception)((Object)e));
        }
        if (elementAt != null) {
            this.selectionElements.add(elementAt);
        }
    }

    private void selectOnMethod(ModuleDeclaration parsedUnit, CallExpression parentCall) {
        IMethod m;
        String methodName = parentCall.getName();
        ASTNode receiver = parentCall.getReceiver();
        ArrayList<IModelElement> availableMethods = new ArrayList<IModelElement>();
        if (receiver == null) {
            ExpressionTypeGoal goal;
            IEvaluatedType type2;
            RubyClassType type = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, this.sourceModule, parsedUnit, parentCall.sourceStart());
            if (type != null && "Object".equals(type.getTypeName()) && (type2 = this.inferencer.evaluateType((AbstractTypeGoal)(goal = new ExpressionTypeGoal((IContext)new BasicContext(this.sourceModule, parsedUnit), (ASTNode)parsedUnit)), 2000)) != null) {
                type = type2;
            }
            IMethod[] m2 = RubyModelUtils.searchClassMethodsExact(this.mixinModel, this.sourceModule, parsedUnit, (IEvaluatedType)type, methodName);
            RubySelectionEngine.addArrayToCollection((IMember[])m2, availableMethods);
        } else {
            ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(this.sourceModule, parsedUnit), receiver);
            IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 5000);
            m = RubyModelUtils.searchClassMethodsExact(this.mixinModel, this.sourceModule, parsedUnit, type, methodName);
            RubySelectionEngine.addArrayToCollection((IMember[])m, availableMethods);
            if (receiver instanceof VariableReference) {
                IMethod[] availableMethods2 = RubyModelUtils.getSingletonMethods(this.mixinModel, (VariableReference)receiver, parsedUnit, this.sourceModule, methodName);
                RubySelectionEngine.addArrayToCollection((IMember[])availableMethods2, availableMethods);
            }
        }
        if (availableMethods.isEmpty()) {
            RubySelectionEngine.searchMethodDeclarations(this.sourceModule.getScriptProject(), methodName, availableMethods);
        }
        if (!availableMethods.isEmpty()) {
            int i = 0;
            int size = availableMethods.size();
            while (i < size) {
                m = (IMethod)availableMethods.get(i);
                if (methodName.equals(methodName)) {
                    this.selectionElements.add((IModelElement)m);
                }
                ++i;
            }
        }
    }

    private static void searchMethodDeclarations(IScriptProject project, String methodName, final List<IModelElement> availableMethods) {
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IModelElement modelElement = (IModelElement)match.getElement();
                ISourceModule sm = (ISourceModule)modelElement.getAncestor(5);
                IModelElement elementAt = sm.getElementAt(match.getOffset());
                if (elementAt.getElementType() == 9) {
                    availableMethods.add(elementAt);
                }
            }
        };
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        try {
            SearchEngine engine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((String)methodName, (int)1, (int)0, (int)8, (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)project));
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            engine.search(pattern, participants, scope, requestor, null);
        }
        catch (CoreException e) {
            RubyPlugin.log((Exception)((Object)e));
        }
    }

    private static void addArrayToCollection(IMember[] src, Collection<IModelElement> dest) {
        if (src != null) {
            int i = 0;
            int size = src.length;
            while (i < size) {
                dest.add((IModelElement)src[i]);
                ++i;
            }
        }
    }
}

