/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.tabs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class HyperLinkDetector
implements IHyperlinkDetector {
    static final String regex = "(?:^|[\\W])((http|https|ftp|file):\\/\\/|[A-Za-z][\\.|\\/])(([\\w\\-]+[\\.|\\/]){1,}?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)";
    static final Pattern pattern = Pattern.compile("(?:^|[\\W])((http|https|ftp|file):\\/\\/|[A-Za-z][\\.|\\/])(([\\w\\-]+[\\.|\\/]){1,}?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)");
    private GerritClient gerritClient;
    private ChangeInfo changeInfo;

    public HyperLinkDetector(GerritClient gerritClient, ChangeInfo changeInfo) {
        this.gerritClient = gerritClient;
        this.changeInfo = changeInfo;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (textViewer.getDocument() == null) {
            return new IHyperlink[0];
        }
        Matcher matcher = pattern.matcher(textViewer.getDocument().get());
        ArrayList<IHyperlink> results = new ArrayList<IHyperlink>();
        while (matcher.find()) {
            results.add((IHyperlink)new URLHyperlink((IRegion)new Region(matcher.start(), matcher.end() - matcher.start()), matcher.group()));
        }
        this.detectHyperlinksForFiles(textViewer, results);
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new IHyperlink[results.size()]);
    }

    private void detectHyperlinksForFiles(ITextViewer textViewer, ArrayList<IHyperlink> results) {
        RevisionInfo revInfo = this.changeInfo.getUserSelectedRevision();
        if (revInfo != null) {
            for (Map.Entry definedFiles : revInfo.getFiles().entrySet()) {
                Pattern pattern2;
                Matcher matcher;
                FileInfo fileInfo = (FileInfo)definedFiles.getValue();
                if (fileInfo.getComments().isEmpty() || !(matcher = (pattern2 = Pattern.compile(fileInfo.getPath().replaceAll("/", "\\\\/"))).matcher(textViewer.getDocument().get())).find(0)) continue;
                Region detectionRegion = new Region(matcher.start(), matcher.end() - matcher.start());
                results.add(new CompareEditorLink(fileInfo, detectionRegion));
            }
        }
    }

    private class CompareEditorLink
    implements IHyperlink {
        private FileInfo fileInfo;
        private IRegion region;

        public CompareEditorLink(FileInfo fileToOpen, Region region) {
            this.fileInfo = fileToOpen;
            this.region = region;
        }

        public void open() {
            UIUtils.open(HyperLinkDetector.this.gerritClient, this.fileInfo, this.getChangeInfo(), "BASE");
        }

        private ChangeInfo getChangeInfo() {
            return this.fileInfo.getRevision().getChangeInfo();
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }
    }

    final class URLHyperlink
    extends org.eclipse.jface.text.hyperlink.URLHyperlink {
        private String label;

        public URLHyperlink(IRegion region, String urlString) {
            super(region, urlString);
            this.label = null;
            this.label = urlString.substring(urlString.lastIndexOf("/"));
        }

        public String getTypeLabel() {
            return this.label;
        }

        public void open() {
            IWebBrowser browser;
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                browser = support.createBrowser(null);
            }
            catch (PartInitException e) {
                super.open();
                return;
            }
            try {
                browser.openURL(new URL(this.getURLString()));
            }
            catch (PartInitException e) {
                super.open();
            }
            catch (MalformedURLException e) {
                super.open();
            }
        }
    }
}

