/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.model.presentation.ViewEditorPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectEClassWizardPage
extends WizardPage {
    private Composite container;
    private Button generateViewModelChkBox;
    private EPackage selectedEPackage;
    private List<EClass> selectedEClasses;
    private TreeViewer treeViewer;

    public SelectEClassWizardPage() {
        super(ViewEditorPlugin.INSTANCE.getString("_UI_SelectEClassWizardPage_page_name"));
        this.setTitle(ViewEditorPlugin.INSTANCE.getString("_UI_SelectEClassWizardPage_page_title"));
        this.setDescription(ViewEditorPlugin.INSTANCE.getString("_UI_SelectEClassWizardPage_page_description"));
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 5;
        this.container.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.container);
        layout.numColumns = 1;
        Label label1 = new Label(this.container, 0);
        label1.setText("Select an EClass:");
        if (this.selectedEPackage != null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
            this.selectedEClasses = new ArrayList<EClass>();
            this.treeViewer = new TreeViewer(this.container, 770);
            this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider((AdapterFactory)adapterFactory));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.treeViewer.setInput((Object)this.selectedEPackage);
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectEClassWizardPage.this.selectedEClasses = new ArrayList();
                    if (event.getSelection() instanceof IStructuredSelection) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        for (Object selectedItem : selection) {
                            if (!EClass.class.isInstance(selectedItem)) continue;
                            SelectEClassWizardPage.this.selectedEClasses.add((EClass)selectedItem);
                            SelectEClassWizardPage.this.setPageComplete(SelectEClassWizardPage.this.getErrorMessage() == null);
                        }
                    }
                    if (SelectEClassWizardPage.this.selectedEClasses.isEmpty()) {
                        SelectEClassWizardPage.this.setPageComplete(false);
                    }
                }
            });
            this.treeViewer.expandToLevel(2);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 200).applyTo(this.treeViewer.getControl());
            this.container.layout(true);
            this.container.pack();
        }
        this.generateViewModelChkBox = new Button(this.container, 32);
        this.generateViewModelChkBox.setText("Fill view model with default layout");
        this.generateViewModelChkBox.setSelection(true);
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.treeViewer != null && this.selectedEPackage != null) {
            this.treeViewer.setInput((Object)this.selectedEPackage);
            this.treeViewer.expandToLevel(2);
        }
    }

    private ITreeContentProvider getContentProvider(AdapterFactory adapterFactory) {
        return new CustomTreeContentProvider(adapterFactory);
    }

    public boolean isGenerateViewModelOptionSelected() {
        return this.generateViewModelChkBox.getSelection();
    }

    public EPackage getSelectedEPackage() {
        return this.selectedEPackage;
    }

    public void setSelectedEPackage(EPackage selectedEPackage) {
        this.selectedEPackage = selectedEPackage;
        if (selectedEPackage == null || selectedEPackage.getNsURI() == null || selectedEPackage.getNsURI().isEmpty()) {
            this.setErrorMessage(ViewEditorPlugin.INSTANCE.getString("_UI_SelectEClassWizardPage_invalid_package_URI"));
        } else {
            this.setErrorMessage(null);
        }
    }

    public void setSelectedEClasses(List<EClass> selectedEClasses) {
        this.selectedEClasses = selectedEClasses;
    }

    public List<EClass> getSelectedEClasses() {
        return this.selectedEClasses;
    }

    public boolean isPageComplete() {
        return this.selectedEClasses != null && !this.selectedEClasses.isEmpty();
    }

    private class CustomTreeContentProvider
    implements ITreeContentProvider {
        private final ResourceSetImpl resourceSet = new ResourceSetImpl();
        private final AdapterFactory adapterFactory;

        CustomTreeContentProvider(AdapterFactory adapterFactory) {
            this.adapterFactory = adapterFactory;
        }

        public boolean hasChildren(Object element) {
            return EPackage.class.isInstance(element);
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (EPackage.class.isInstance(parentElement)) {
                LinkedHashSet<EObject> children = new LinkedHashSet<EObject>();
                children.addAll((Collection<EObject>)((EPackage)EPackage.class.cast(parentElement)).getESubpackages());
                for (EObject obj : ((EPackage)EPackage.class.cast(parentElement)).getEClassifiers()) {
                    EClass eClass;
                    if (!EClass.class.isInstance(obj) || (eClass = (EClass)EClass.class.cast(obj)).isAbstract() || eClass.isInterface()) continue;
                    children.add(obj);
                }
                return children.toArray();
            }
            if (IFile.class.isInstance(parentElement)) {
                String path = ((IFile)parentElement).getFullPath().toString();
                URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
                ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(parentElement = this.resourceSet.getResource(uri, true), ITreeItemContentProvider.class);
                return (treeItemContentProvider != null ? treeItemContentProvider.getChildren(parentElement) : Collections.EMPTY_LIST).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

