/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.java.sdk.ui.internal.wizard.page;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.ETypedElementCase;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.exported.IQueryContext;
import org.eclipse.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.emf.facet.query.java.sdk.ui.internal.Activator;
import org.eclipse.emf.facet.query.java.sdk.ui.internal.Messages;
import org.eclipse.emf.facet.query.java.sdk.ui.internal.wizard.JavaQueryUtils;
import org.eclipse.emf.facet.query.java.sdk.ui.internal.wizard.JdtUtils;
import org.eclipse.emf.facet.query.java.sdk.ui.internal.wizard.page.NewClassWizardPage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.core.internal.exported.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CreateQueryClassWizardPage
extends NewClassWizardPage {
    public CreateQueryClassWizardPage(IQueryContext queryContainer) {
        IJavaProject javaProject = JavaCore.create((IProject)queryContainer.getProject());
        ArrayList<String> interfaceList = new ArrayList<String>();
        interfaceList.add(IJavaQuery2.class.getName());
        this.setSuperInterfaces(interfaceList, false);
        String packageName = JavaQueryUtils.getDefaultPackageName(queryContainer, javaProject);
        String typeName = CreateQueryClassWizardPage.getClassName(queryContainer);
        this.setTypeName(typeName, true);
        this.selectPackage(javaProject, packageName);
        this.setModifiers(this.F_PUBLIC, false);
        this.setSuperClass("", false);
        this.setEnclosingTypeSelection(false, false);
        this.setAddComments(false, false);
    }

    private static String getClassName(IQueryContext queryContext) {
        StringBuffer result = new StringBuffer();
        EObject intermediate = queryContext.getIntermediateEObject();
        if (intermediate instanceof ETypedElementCase) {
            ETypedElementCase eteCase = (ETypedElementCase)intermediate;
            String caseLabel = "";
            if (eteCase.getCase() != null) {
                caseLabel = eteCase.getCase().getName();
            }
            result.append(StringUtils.firstLetterToUpperCase((String)caseLabel));
        }
        result.append(StringUtils.firstLetterToUpperCase((String)queryContext.getDerivedTypedElementName()));
        result.append("Query");
        return result.toString();
    }

    private void selectPackage(IJavaProject javaProject, String packageName) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRootToTest = iPackageFragmentRootArray[n2];
                if (packageFragmentRootToTest.getKind() == 1) {
                    IPackageFragmentRoot pkgFragmentRoot = packageFragmentRootToTest;
                    this.setPackageFragmentRoot(pkgFragmentRoot, false);
                    IPackageFragment packageFragment = pkgFragmentRoot.getPackageFragment(packageName);
                    this.setPackageFragment(packageFragment, true);
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e1) {
            Logger.logError((Throwable)e1, (Plugin)Activator.getDefault());
        }
    }

    public String apply(EClassifier returnType, boolean multiValues, EClassifier scope) {
        String result = "";
        try {
            IPackageFragmentRoot root = this.getPackageFragmentRoot();
            IPackageFragment packageFragment = this.getPackageFragment();
            String typeName = this.getTypeName();
            String cuName = this.getCompilationUnitName(typeName);
            ICompilationUnit javaClass = JdtUtils.createJavaClass(returnType, multiValues, scope, packageFragment, root, typeName, cuName);
            IProject project = javaClass.getCorrespondingResource().getProject();
            JdtUtils.setupProject(project, returnType, scope);
            result = String.valueOf(packageFragment.getElementName()) + '.' + typeName;
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewQueryClassWizardPage_Failed_to_create_java_class, (String)Messages.NewQueryClassWizardPage_Failed_to_create_query_implementation);
        }
        return result;
    }
}

