/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.core.util.Logs;

public class ReportProcessorSafeWrapper
implements IReportProcessor {
    private IReportProcessor reportProcessor;

    public ReportProcessorSafeWrapper(IReportProcessor reportProcessor) {
        this.reportProcessor = reportProcessor;
    }

    public boolean canContribute(IStatus status, IEclipseContext context) {
        try {
            return this.reportProcessor.canContribute(status, context);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORT_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{this.reportProcessor});
            return false;
        }
    }

    public boolean wantsToContribute(IStatus status, IEclipseContext context) {
        try {
            return this.reportProcessor.wantsToContribute(status, context);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORT_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{this.reportProcessor});
            return false;
        }
    }

    public void process(IReport report, IStatus status, IEclipseContext context) {
        try {
            this.reportProcessor.process(report, status, context);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORT_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{this.reportProcessor});
        }
    }

    public IReportProcessor getWrapped() {
        return this.reportProcessor;
    }
}

