/**
 * <copyright>
 * 
 * Copyright (c) 2005, 2012 SAP AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    SAP AG - initial API, implementation and documentation
 *    Benjamin Schmeling - mwenz - Bug 367483 - Support composite connections
 * 
 * </copyright>
 */
package org.eclipse.graphiti.mm.pictograms;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.graphiti.mm.pictograms.PictogramsPackage
 * @generated
 */
public interface PictogramsFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PictogramsFactory eINSTANCE = org.eclipse.graphiti.mm.pictograms.impl.PictogramsFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Shape</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Shape</em>'.
	 * @generated
	 */
	Shape createShape();

	/**
	 * Returns a new object of class '<em>Container Shape</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Container Shape</em>'.
	 * @generated
	 */
	ContainerShape createContainerShape();

	/**
	 * Returns a new object of class '<em>Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Diagram</em>'.
	 * @generated
	 */
	Diagram createDiagram();

	/**
	 * Returns a new object of class '<em>Connection</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Connection</em>'.
	 * @generated
	 */
	Connection createConnection();

	/**
	 * Returns a new object of class '<em>Fix Point Anchor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Fix Point Anchor</em>'.
	 * @generated
	 */
	FixPointAnchor createFixPointAnchor();

	/**
	 * Returns a new object of class '<em>Box Relative Anchor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Box Relative Anchor</em>'.
	 * @generated
	 */
	BoxRelativeAnchor createBoxRelativeAnchor();

	/**
	 * Returns a new object of class '<em>Chopbox Anchor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Chopbox Anchor</em>'.
	 * @generated
	 */
	ChopboxAnchor createChopboxAnchor();

	/**
	 * Returns a new object of class '<em>Connection Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Connection Decorator</em>'.
	 * @generated
	 */
	ConnectionDecorator createConnectionDecorator();

	/**
	 * Returns a new object of class '<em>Free Form Connection</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Free Form Connection</em>'.
	 * @generated
	 */
	FreeFormConnection createFreeFormConnection();

	/**
	 * Returns a new object of class '<em>Manhattan Connection</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Manhattan Connection</em>'.
	 * @generated
	 */
	ManhattanConnection createManhattanConnection();

	/**
	 * Returns a new object of class '<em>Pictogram Link</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pictogram Link</em>'.
	 * @generated
	 */
	PictogramLink createPictogramLink();

	/**
	 * Returns a new object of class '<em>Curved Connection</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Curved Connection</em>'.
	 * @generated
	 * @since 0.9
	 */
	CurvedConnection createCurvedConnection();

	/**
	 * Returns a new object of class '<em>Composite Connection</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Composite Connection</em>'.
	 * @generated
	 * @since 0.9
	 */
	CompositeConnection createCompositeConnection();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	PictogramsPackage getPictogramsPackage();

} //PictogramsFactory
