/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.binary.StubCreator;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CallInliner;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ReplaceInvocationsRefactoring
extends Refactoring {
    private static final String ID_REPLACE_INVOCATIONS = "org.eclipse.jdt.ui.replace.invocations";
    private static final String ATTRIBUTE_MODE = "mode";
    private final ITypeRoot fSelectionTypeRoot;
    private final int fSelectionStart;
    private final int fSelectionLength;
    private ASTNode fSelectionNode;
    private IMethod fMethod;
    private String fBody;
    private String[] fParameterNames;
    private SourceProvider fSourceProvider;
    private TargetProvider fTargetProvider;
    private TextChangeManager fChangeManager;
    private IMethodBinding fMethodBinding;

    public ReplaceInvocationsRefactoring(ITypeRoot typeRoot, int offset, int length) {
        this.fSelectionTypeRoot = typeRoot;
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
    }

    public ReplaceInvocationsRefactoring(IMethod method) {
        this.fMethod = method;
        this.fSelectionTypeRoot = method.getTypeRoot();
        this.fSelectionStart = -1;
        this.fSelectionLength = -1;
    }

    public ReplaceInvocationsRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public String getName() {
        return RefactoringCoreMessages.ReplaceInvocationsRefactoring_name;
    }

    public boolean canReplaceSingle() {
        return this.fSelectionNode instanceof MethodInvocation;
    }

    public RefactoringStatus setCurrentMode(Mode mode) throws JavaModelException {
        if (this.fTargetProvider.isSingle() == (mode == Mode.REPLACE_SINGLE)) {
            return new RefactoringStatus();
        }
        Assert.isTrue((boolean)this.canReplaceSingle());
        this.fTargetProvider = mode == Mode.REPLACE_SINGLE ? TargetProvider.create((ICompilationUnit)this.fSelectionTypeRoot, (MethodInvocation)this.fSelectionNode) : TargetProvider.create(this.fSourceProvider.getDeclaration());
        return this.fTargetProvider.checkActivation();
    }

    public void setBody(String body, String[] parameterNames) {
        this.fBody = body;
        this.fParameterNames = parameterNames;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fMethod == null) {
            if (!(this.fSelectionTypeRoot instanceof ICompilationUnit)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReplaceInvocationsRefactoring_cannot_replace_in_binary);
            }
            ICompilationUnit cu = (ICompilationUnit)this.fSelectionTypeRoot;
            CompilationUnit root = new RefactoringASTParser(9).parse((ITypeRoot)cu, true);
            this.fSelectionNode = ReplaceInvocationsRefactoring.getTargetNode(cu, root, this.fSelectionStart, this.fSelectionLength);
            if (this.fSelectionNode == null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReplaceInvocationsRefactoring_select_method_to_apply);
            }
            if (this.fSelectionNode.getNodeType() == 31) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)this.fSelectionNode;
                this.fTargetProvider = TargetProvider.create(methodDeclaration);
                this.fMethodBinding = methodDeclaration.resolveBinding();
            } else {
                MethodInvocation methodInvocation = (MethodInvocation)this.fSelectionNode;
                this.fTargetProvider = TargetProvider.create(cu, methodInvocation);
                this.fMethodBinding = methodInvocation.resolveMethodBinding();
            }
            if (this.fMethodBinding == null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            }
            this.fMethod = (IMethod)this.fMethodBinding.getJavaElement();
        } else {
            ASTParser parser = ASTParser.newParser((int)9);
            parser.setProject(this.fMethod.getJavaProject());
            IBinding[] bindings = parser.createBindings(new IJavaElement[]{this.fMethod}, null);
            this.fMethodBinding = (IMethodBinding)bindings[0];
            if (this.fMethodBinding == null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            }
            this.fTargetProvider = TargetProvider.create(this.fMethodBinding);
        }
        result.merge(this.fTargetProvider.checkActivation());
        return result;
    }

    private SourceProvider resolveSourceProvider(IMethodBinding methodBinding, RefactoringStatus status) throws JavaModelException {
        CompilationUnit methodDeclarationAstRoot;
        Document source;
        ICompilationUnit typeRoot;
        final IMethod method = (IMethod)methodBinding.getJavaElement();
        ICompilationUnit methodCu = method.getCompilationUnit();
        if (methodCu != null) {
            typeRoot = methodCu;
            ASTParser parser = ASTParser.newParser((int)9);
            parser.setSource(methodCu);
            parser.setFocalPosition(method.getNameRange().getOffset());
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
            MethodDeclaration methodDecl = (MethodDeclaration)NodeFinder.perform((ASTNode)compilationUnit, (ISourceRange)method.getNameRange()).getParent();
            AST ast = compilationUnit.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Block newBody = ast.newBlock();
            newBody.statements().add(rewrite.createStringPlaceholder(this.fBody, 20));
            rewrite.replace((ASTNode)methodDecl.getBody(), (ASTNode)newBody, null);
            List parameters = methodDecl.parameters();
            int i = 0;
            while (i < parameters.size()) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(i);
                rewrite.set((ASTNode)parameter.getName(), (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)this.fParameterNames[i], null);
                ++i;
            }
            TextEdit textEdit = rewrite.rewriteAST();
            Document document = new Document(methodCu.getBuffer().getContents());
            try {
                textEdit.apply((IDocument)document);
            }
            catch (MalformedTreeException e) {
                JavaPlugin.log(e);
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            source = document;
            methodDeclarationAstRoot = new RefactoringASTParser(9).parse(source.get(), methodCu, true, true, null);
        } else {
            IOrdinaryClassFile classFile = (IOrdinaryClassFile)method.getClassFile();
            StubCreator stubCreator = new StubCreator(true){

                @Override
                protected void appendMethodBody(IMethod currentMethod) throws JavaModelException {
                    if (currentMethod.equals(method)) {
                        this.fBuffer.append(ReplaceInvocationsRefactoring.this.fBody);
                    } else {
                        super.appendMethodBody(currentMethod);
                    }
                }

                @Override
                protected void appendMethodParameterName(IMethod currentMethod, int index) {
                    if (currentMethod.equals(method)) {
                        this.fBuffer.append(ReplaceInvocationsRefactoring.this.fParameterNames[index]);
                    } else {
                        super.appendMethodParameterName(currentMethod, index);
                    }
                }
            };
            String stub = stubCreator.createStub(classFile.getType(), null);
            source = new Document(stub);
            methodDeclarationAstRoot = new RefactoringASTParser(9).parse(stub, (IClassFile)classFile, true, true, null);
            typeRoot = classFile;
        }
        ASTNode node = methodDeclarationAstRoot.findDeclaringNode(methodBinding.getKey());
        if (node instanceof MethodDeclaration) {
            return new SourceProvider((ITypeRoot)typeRoot, (IDocument)source, (MethodDeclaration)node);
        }
        status.addFatalError(RefactoringCoreMessages.ReplaceInvocationsRefactoring_cannot_find_method_declaration);
        return null;
    }

    private static ASTNode getTargetNode(ICompilationUnit unit, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = ReplaceInvocationsRefactoring.checkNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length, (ITypeRoot)unit));
        }
        catch (JavaModelException javaModelException) {}
        if (node != null) {
            return node;
        }
        return ReplaceInvocationsRefactoring.checkNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    private static ASTNode checkNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 42) {
            node = node.getParent();
        } else if (node.getNodeType() == 21) {
            node = ((ExpressionStatement)node).getExpression();
        }
        switch (node.getNodeType()) {
            case 31: 
            case 32: {
                return node;
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 20);
        this.fChangeManager = new TextChangeManager();
        RefactoringStatus result = new RefactoringStatus();
        this.fSourceProvider = this.resolveSourceProvider(this.fMethodBinding, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(this.fSourceProvider.checkActivation());
        if (result.hasFatalError()) {
            return result;
        }
        this.fSourceProvider.initialize();
        this.fTargetProvider.initialize();
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_searching);
        RefactoringStatus searchStatus = new RefactoringStatus();
        String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName((String)this.fSourceProvider.getMethodName()));
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        ICompilationUnit[] units = this.fTargetProvider.getAffectedCompilationUnits(searchStatus, binaryRefs, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        binaryRefs.addErrorIfNecessary(searchStatus);
        if (searchStatus.hasFatalError()) {
            result.merge(searchStatus);
            return result;
        }
        IFile[] filesToBeModified = this.getFilesToBeModified(units);
        result.merge(Checks.validateModifiesFiles(filesToBeModified, this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeModified, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        this.checkOverridden(result, (IProgressMonitor)new SubProgressMonitor(pm, 4));
        SubProgressMonitor sub = new SubProgressMonitor(pm, 15);
        sub.beginTask("", units.length * 3);
        int c = 0;
        while (c < units.length) {
            block17: {
                ICompilationUnit unit = units[c];
                sub.subTask(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_processing, BasicElementLabels.getFileName((ITypeRoot)unit)));
                CallInliner inliner = null;
                try {
                    boolean added = false;
                    MultiTextEdit root = new MultiTextEdit();
                    CompilationUnitChange change = (CompilationUnitChange)this.fChangeManager.get(unit);
                    change.setEdit((TextEdit)root);
                    BodyDeclaration[] bodies = this.fTargetProvider.getAffectedBodyDeclarations(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (bodies.length == 0) break block17;
                    inliner = new CallInliner(unit, (CompilationUnit)bodies[0].getRoot(), this.fSourceProvider);
                    int b = 0;
                    while (b < bodies.length) {
                        BodyDeclaration body = bodies[b];
                        inliner.initialize(body);
                        RefactoringStatus nestedInvocations = new RefactoringStatus();
                        ASTNode[] invocations = this.removeNestedCalls(nestedInvocations, unit, this.fTargetProvider.getInvocations(body, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 2)));
                        int i = 0;
                        while (i < invocations.length) {
                            ASTNode invocation = invocations[i];
                            result.merge(inliner.initialize(invocation, this.fTargetProvider.getStatusSeverity()));
                            if (result.hasFatalError()) break;
                            if (result.getSeverity() < this.fTargetProvider.getStatusSeverity()) {
                                added = true;
                                TextEditGroup group = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_inline);
                                change.addTextEditGroup(group);
                                result.merge(inliner.perform(group));
                            }
                            ++i;
                        }
                        result.merge(nestedInvocations);
                        ++b;
                    }
                    if (!added) {
                        this.fChangeManager.remove(unit);
                    } else {
                        TextEdit edit;
                        root.addChild(inliner.getModifications());
                        ImportRewrite rewrite = inliner.getImportEdit();
                        if (rewrite.hasRecordedChanges() && (!((edit = rewrite.rewriteImports(null)) instanceof MultiTextEdit) || ((MultiTextEdit)edit).getChildrenSize() > 0)) {
                            root.addChild(edit);
                            change.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_import, new TextEdit[]{edit}));
                        }
                    }
                }
                finally {
                    if (inliner != null) {
                        inliner.dispose();
                    }
                }
                sub.worked(1);
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++c;
        }
        result.merge(searchStatus);
        sub.done();
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fSelectionTypeRoot.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        IMethodBinding binding = this.fSourceProvider.getDeclaration().resolveBinding();
        int flags = 786434;
        if (!Modifier.isPrivate((int)binding.getModifiers())) {
            flags |= 4;
        }
        String description = Messages.format(RefactoringCoreMessages.ReplaceInvocationsRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName((String)binding.getName()));
        String header = Messages.format(RefactoringCoreMessages.ReplaceInvocationsRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)binding.getDeclaringClass(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ReplaceInvocationsRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        if (!this.fTargetProvider.isSingle()) {
            comment.addSetting(RefactoringCoreMessages.ReplaceInvocationsRefactoring_replace_references);
        }
        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_REPLACE_INVOCATIONS, project, description, comment.asString(), arguments, flags){};
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fSelectionTypeRoot));
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_MODE, new Integer(this.fTargetProvider.isSingle() ? 0 : 1).toString());
        return new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ReplaceInvocationsRefactoring_change_name, (Change[])this.fChangeManager.getAllChanges());
    }

    private IFile[] getFilesToBeModified(ICompilationUnit[] units) {
        ArrayList<IFile> result = new ArrayList<IFile>(units.length + 1);
        int i = 0;
        while (i < units.length) {
            IFile file = this.getFile(units[i]);
            if (file != null) {
                result.add(file);
            }
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    private IFile getFile(ICompilationUnit unit) {
        IResource resource = (unit = unit.getPrimary()).getResource();
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    private void checkOverridden(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden);
        MethodDeclaration decl = this.fSourceProvider.getDeclaration();
        IMethod method = (IMethod)decl.resolveBinding().getJavaElement();
        if (method == null || Flags.isPrivate((int)method.getFlags())) {
            pm.worked(8);
            return;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 6));
        this.checkSubTypes(status, method, hierarchy.getAllSubtypes(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperClasses(status, method, hierarchy.getAllSuperclasses(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperInterfaces(status, method, hierarchy.getAllSuperInterfaces(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.setTaskName("");
    }

    private void checkSubTypes(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden_error, pm);
    }

    private void checkSuperClasses(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overrides_error, pm);
    }

    private void checkSuperInterfaces(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_implements_error, pm);
    }

    private void checkTypes(RefactoringStatus result, IMethod method, IType[] types, String key, IProgressMonitor pm) {
        pm.beginTask("", types.length);
        int i = 0;
        while (i < types.length) {
            pm.worked(1);
            IMethod[] overridden = types[i].findMethods(method);
            if (overridden != null && overridden.length > 0) {
                result.addError(Messages.format(key, BasicElementLabels.getJavaElementName((String)types[i].getElementName())), JavaStatusContext.create((IMember)overridden[0]));
            }
            ++i;
        }
    }

    private ASTNode[] removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] invocations) {
        if (invocations.length <= 1) {
            return invocations;
        }
        ASTNode[] parents = new ASTNode[invocations.length];
        int i = 0;
        while (i < invocations.length) {
            parents[i] = invocations[i].getParent();
            ++i;
        }
        i = 0;
        while (i < invocations.length) {
            this.removeNestedCalls(status, unit, parents, invocations, i);
            ++i;
        }
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        int i2 = 0;
        while (i2 < invocations.length) {
            if (invocations[i2] != null) {
                result.add(invocations[i2]);
            }
            ++i2;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    private void removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] parents, ASTNode[] invocations, int index) {
        ASTNode invocation = invocations[index];
        int i = 0;
        while (i < parents.length) {
            ASTNode parent = parents[i];
            while (parent != null) {
                if (parent == invocation) {
                    status.addError(RefactoringCoreMessages.InlineMethodRefactoring_nestedInvocation, JavaStatusContext.create((ITypeRoot)unit, parent));
                    invocations[index] = null;
                }
                parent = parent.getParent();
            }
            ++i;
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String value = arguments.getAttribute(ATTRIBUTE_MODE);
        if (value != null && !"".equals(value)) {
            int mode = 0;
            try {
                mode = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MODE));
            }
            try {
                this.setCurrentMode(mode == 1 ? Mode.REPLACE_ALL : Mode.REPLACE_SINGLE);
            }
            catch (JavaModelException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage());
            }
        }
        return new RefactoringStatus();
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public static class Mode {
        public static final Mode REPLACE_ALL = new Mode();
        public static final Mode REPLACE_SINGLE = new Mode();

        private Mode() {
        }
    }
}

