/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.atomic.AtomicLong;

public final class NonBlockingLongCounter {
    private AtomicLong value;

    public NonBlockingLongCounter() {
        this(0L);
    }

    public NonBlockingLongCounter(long initialValue) {
        this.value = new AtomicLong(initialValue);
    }

    public long getValue() {
        return this.value.get();
    }

    public long increment() {
        long v;
        while (!this.value.compareAndSet(v = this.value.get(), v + 1L)) {
        }
        return v + 1L;
    }

    public long decrement() {
        long v;
        while (!this.value.compareAndSet(v = this.value.get(), v - 1L)) {
        }
        return v - 1L;
    }

    public String toString() {
        return Long.toString(this.getValue());
    }
}

