/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.language.ILanguageModelProvider;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.language.Messages;

class DefaultLanguageModelProvider
implements ILanguageModelProvider {
    private static final String LANGUAGE_LIBRARY_PATH = "$nl$/Resources/language/php";

    DefaultLanguageModelProvider() {
    }

    @Override
    public IPath getPath(IScriptProject project) {
        try {
            return new Path(this.getLanguageLibraryPath(project, ProjectOptions.getPHPVersion((IModelElement)project)));
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    @Override
    public String getName() {
        return Messages.DefaultLanguageModelProvider_1;
    }

    private String getLanguageLibraryPath(IScriptProject project, PHPVersion phpVersion) {
        if (phpVersion == PHPVersion.PHP5) {
            return "$nl$/Resources/language/php5";
        }
        if (phpVersion == PHPVersion.PHP5_3) {
            return "$nl$/Resources/language/php5.3";
        }
        if (phpVersion == PHPVersion.PHP5_4) {
            return "$nl$/Resources/language/php5.4";
        }
        if (phpVersion == PHPVersion.PHP5_5) {
            return "$nl$/Resources/language/php5.5";
        }
        if (phpVersion == PHPVersion.PHP5_6) {
            return "$nl$/Resources/language/php5.6";
        }
        if (phpVersion == PHPVersion.PHP7_0) {
            return "$nl$/Resources/language/php7";
        }
        if (phpVersion == PHPVersion.PHP7_1) {
            return "$nl$/Resources/language/php71";
        }
        return "$nl$/Resources/language/php72";
    }

    @Override
    public Plugin getPlugin() {
        return PHPCorePlugin.getDefault();
    }
}

