/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAddress;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueNamed;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValuePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.internal.debug.core.pdi.aif.ValueDerived;
import org.eclipse.ptp.internal.debug.core.pdi.aif.ValueIntegral;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFValuePointer
extends ValueDerived
implements IAIFValuePointer {
    private IAIFValue value = null;
    private IAIFValue addrValue = null;

    public AIFValuePointer(IValueParent parent, IAIFTypePointer type, AIFFactory.SimpleByteBuffer buffer) {
        super(parent, type);
        this.parse(buffer);
    }

    @Override
    public IAIFValue getValue() {
        if (this.value instanceof IAIFValueNamed) {
            return ((IAIFValueNamed)this.value).getValue();
        }
        return this.value;
    }

    @Override
    public String getValueString() throws AIFException {
        if (this.addrValue != null) {
            return this.addrValue.getValueString();
        }
        return "";
    }

    @Override
    public int length() throws AIFException {
        int children = this.value.length();
        if (children == 0) {
            return 1;
        }
        return children;
    }

    @Override
    public BigInteger pointerValue() throws AIFException {
        if (this.addrValue == null) {
            return BigInteger.ZERO;
        }
        return ValueIntegral.bigIntegerValue(this.addrValue.getValueString());
    }

    @Override
    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        byte marker = buffer.get();
        IAIFTypePointer pType = (IAIFTypePointer)this.getType();
        switch (marker) {
            case 0: {
                IAIFTypeAddress aType = pType.getAddressType();
                this.addrValue = AIFFactory.getAIFValue(null, (IAIFType)aType, new byte[aType.sizeof()]);
                this.value = AIFFactory.UNKNOWNVALUE;
                break;
            }
            case 1: {
                this.addrValue = AIFFactory.getAIFValue(null, (IAIFType)pType.getAddressType(), buffer);
                this.value = AIFFactory.getAIFValue(this.getParent(), pType.getBaseType(), buffer);
                this.setSize(this.addrValue.sizeof() + this.value.sizeof());
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.value = AIFFactory.UNKNOWNVALUE;
            }
        }
    }
}

