/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.internal.rm.lml.core.model.Node;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.elements.UsageType;
import org.eclipse.ptp.rm.lml.core.model.LMLNodeData;

public class TreeExpansion {
    private static final boolean generateAllLeaves = true;
    private final Nodedisplay nodedisplay;

    public static void expandLMLNode(Node<LMLNodeData> node, int maxLevel) {
        LMLNodeData data = node.getData();
        int currentLevel = data.getLevelIds().size();
        List<Node<LMLNodeData>> childrenNodes = node.getChildren();
        if (currentLevel >= maxLevel) {
            return;
        }
        childrenNodes.clear();
        ArrayList<LMLNodeData> childrenData = data.getLowerNodes();
        for (LMLNodeData nodeData : childrenData) {
            Node<LMLNodeData> newNode = new Node<LMLNodeData>(nodeData);
            TreeExpansion.expandLMLNode(newNode, maxLevel);
            childrenNodes.add(newNode);
        }
    }

    public static void generateUsagebarsForAllLeaves(Node<LMLNodeData> node) {
        LMLNodeData lmlNodeData = node.getData();
        if (lmlNodeData.isRootNode()) {
            for (Node<LMLNodeData> child : node.getChildren()) {
                TreeExpansion.generateUsagebarsForAllLeaves(child);
            }
            return;
        }
        if (lmlNodeData.isDataElementOnNodeLevel()) {
            if (node.getChildren().size() == 0) {
                UsageType usage = lmlNodeData.generateUsage();
                if (usage.getJob().size() == 1 && usage.getJob().get(0).getOid().equals(lmlNodeData.getDataElement().getOid())) {
                    return;
                }
                lmlNodeData.getDataElement().setUsage(usage);
            } else {
                for (Node<LMLNodeData> child : node.getChildren()) {
                    TreeExpansion.generateUsagebarsForAllLeaves(child);
                }
            }
        }
    }

    public TreeExpansion(Nodedisplay nodedisplay) {
        this.nodedisplay = nodedisplay;
    }

    public Node<LMLNodeData> getFullTree(int maxLevel) {
        LMLNodeData rootData = new LMLNodeData(this.nodedisplay.getData(), this.nodedisplay.getScheme(), new ArrayList<Integer>(), "");
        Node<LMLNodeData> root = new Node<LMLNodeData>(rootData);
        TreeExpansion.expandLMLNode(root, maxLevel);
        return root;
    }

    public Nodedisplay getNodedisplay() {
        return this.nodedisplay;
    }
}

