/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.internal.DeclarativeVersionCompatibilityService;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class VersionCompatibilityFactsService
extends FactsService {
    @Text(value="For {0} {1}")
    private static LocalizableText forVersionsFact;
    @Text(value="Since {0} {1}")
    private static LocalizableText sinceVersionFact;

    static {
        LocalizableText.init(VersionCompatibilityFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        DeclarativeVersionCompatibilityService service = VersionCompatibilityFactsService.findDeclarativeVersionCompatibilityService(this.context(Property.class));
        if (service != null) {
            String versioned = service.versioned();
            VersionConstraint constraint = service.constraint();
            if (versioned != null && constraint != null) {
                Version since = null;
                if (constraint.ranges().size() == 1) {
                    VersionConstraint.Range range = constraint.ranges().get(0);
                    VersionConstraint.Range.Limit min = range.min();
                    VersionConstraint.Range.Limit max = range.max();
                    if (min != null && min.inclusive() && max == null) {
                        since = min.version();
                    }
                }
                if (since != null) {
                    facts.add(sinceVersionFact.format(versioned, since));
                } else {
                    facts.add(forVersionsFact.format(versioned, constraint));
                }
            }
        }
    }

    private static DeclarativeVersionCompatibilityService findDeclarativeVersionCompatibilityService(Property property) {
        Property parent;
        DeclarativeVersionCompatibilityService service = property.service(DeclarativeVersionCompatibilityService.class);
        if (service == null && (parent = property.element().parent()) != null) {
            service = VersionCompatibilityFactsService.findDeclarativeVersionCompatibilityService(parent);
        }
        return service;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            return VersionCompatibilityFactsService.findDeclarativeVersionCompatibilityService(context.find(Property.class)) != null;
        }
    }
}

