/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class FileExtensionsFactsService
extends FactsService {
    @Text(value="Must have \"{0}\" file extension")
    private static LocalizableText statementForOne;
    @Text(value="Must have either \"{0}\" or \"{1}\" file extension")
    private static LocalizableText statementForTwo;
    @Text(value="Must have either \"{0}\", \"{1}\" or \"{2}\" file extension")
    private static LocalizableText statementForThree;
    @Text(value="Must have one of these file extensions: {0}")
    private static LocalizableText statementForMany;

    static {
        LocalizableText.init(FileExtensionsFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        FileExtensionsService service = this.context(Property.class).service(FileExtensionsService.class);
        List<String> extensions = service.extensions();
        int count = extensions.size();
        if (count > 0) {
            if (count == 1) {
                facts.add(statementForOne.format(extensions.get(0)));
            } else if (count == 2) {
                facts.add(statementForTwo.format(extensions.get(0), extensions.get(1)));
            } else if (count == 3) {
                facts.add(statementForThree.format(extensions.get(0), extensions.get(1), extensions.get(2)));
            } else {
                StringBuilder buf = new StringBuilder();
                for (String extension : extensions) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append('\"');
                    buf.append(extension);
                    buf.append('\"');
                }
                facts.add(statementForMany.format(buf.toString()));
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            return property != null && property.service(FileExtensionsService.class) != null;
        }
    }
}

