/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.sphinx.emf.search.ui.ModelSearchQuery;
import org.eclipse.sphinx.emf.search.ui.QuerySpecification;
import org.eclipse.sphinx.emf.search.ui.internal.Activator;
import org.eclipse.sphinx.emf.search.ui.internal.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;

public class ModelSearchPage
extends DialogPage
implements ISearchPage {
    private static final String PAGE_NAME = "ModelSearchPage";
    private static final int HISTORY_SIZE = 12;
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private boolean firstTime = true;
    private boolean isCaseSensitive;
    private IDialogSettings dialogSettings;
    private ISearchPageContainer pageContainer;
    private Combo pattern;
    private Button caseSensitive;
    private SearchPatternData initialData;
    private final List<SearchPatternData> previousSearchPatterns = new ArrayList<SearchPatternData>();

    public ModelSearchPage() {
        super(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        Control expressionComposite = this.createExpression(composite);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText(Messages.ModelSearchPage_expression_label);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.pattern = new Combo(result, 2052);
        this.pattern.setVisibleItemCount(12);
        this.pattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSearchPage.this.handlePatternSelected();
                ModelSearchPage.this.updateOKStatus();
            }
        });
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.pattern.setLayoutData((Object)data);
        this.caseSensitive = new Button(result, 32);
        this.caseSensitive.setText(Messages.ModelSearchPage_expression_caseSensitive);
        this.caseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSearchPage.this.isCaseSensitive = ModelSearchPage.this.caseSensitive.getSelection();
            }
        });
        this.caseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    private String getPattern() {
        return this.pattern.getText();
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.previousSearchPatterns) {
            if (!pattern.equals(element.getPattern())) continue;
            return element;
        }
        return null;
    }

    private void handlePatternSelected() {
        int selectionIndex = this.pattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.previousSearchPatterns.size()) {
            return;
        }
        SearchPatternData initialData = this.previousSearchPatterns.get(selectionIndex);
        this.pattern.setText(initialData.getPattern());
        this.isCaseSensitive = initialData.isCaseSensitive();
        this.caseSensitive.setEnabled(true);
        this.caseSensitive.setSelection(this.isCaseSensitive);
        this.getContainer().setSelectedScope(initialData.getScope());
        this.initialData = initialData;
    }

    protected void updateOKStatus() {
        boolean isValidPattern = this.isValidSearchPattern();
        this.getContainer().setPerformActionEnabled(isValidPattern);
    }

    private boolean isValidSearchPattern() {
        return !this.getPattern().isEmpty();
    }

    public boolean performAction() {
        SearchPatternData patternData = this.getPatternData();
        QuerySpecification querySpec = new QuerySpecification(patternData.getPattern(), patternData.isCaseSensitive(), Collections.emptySet());
        ModelSearchQuery modelSearchQuery = new ModelSearchQuery(querySpec);
        NewSearchUI.runQueryInBackground((ISearchQuery)modelSearchQuery);
        return true;
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = this.findInPrevious(pattern);
        if (match != null) {
            this.previousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(pattern, this.caseSensitive.getSelection(), this.getContainer().getSelectedScope());
        this.previousSearchPatterns.add(0, match);
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.pattern != null) {
            if (this.firstTime) {
                this.firstTime = false;
                this.pattern.setItems(this.getPreviousSearchPatterns());
            }
            this.pattern.setFocus();
        }
        this.updateOKStatus();
        IEditorInput editorInput = this.getContainer().getActiveEditorInput();
        this.getContainer().setActiveEditorCanProvideScopeSelection(editorInput != null && editorInput.getAdapter(IFile.class) != null);
        super.setVisible(visible);
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = this.previousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = this.previousSearchPatterns.get(i).getPattern();
            ++i;
        }
        return patterns;
    }

    public void setContainer(ISearchPageContainer container) {
        this.pageContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.pageContainer;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = Activator.getDefault().getDialogSettingsSection(PAGE_NAME);
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.isCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.previousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.isCaseSensitive);
        int historySize = Math.min(this.previousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = this.previousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private static class SearchPatternData {
        private final int scope;
        private static final String SCOPE = "scope";
        private final String pattern;
        private static final String PATTERN = "pattern";
        private final boolean isCaseSensitive;
        private static final String IS_CASE_SENSITIVE = "isCaseSensitive";

        public SearchPatternData(String pattern, boolean isCaseSensitive, int scope) {
            this.scope = scope;
            this.pattern = pattern;
            this.isCaseSensitive = isCaseSensitive;
        }

        public int getScope() {
            return this.scope;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public void store(IDialogSettings settings) {
            settings.put(IS_CASE_SENSITIVE, this.isCaseSensitive);
            settings.put(PATTERN, this.pattern);
            settings.put(SCOPE, this.scope);
        }

        public static SearchPatternData create(IDialogSettings settings) {
            int scope;
            String pattern = settings.get(PATTERN);
            if (pattern.length() == 0) {
                return null;
            }
            boolean isCaseSensitive = settings.getBoolean(IS_CASE_SENSITIVE);
            try {
                scope = settings.getInt(SCOPE);
            }
            catch (NumberFormatException ex) {
                scope = 0;
            }
            return new SearchPatternData(pattern, isCaseSensitive, scope);
        }
    }
}

