/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;

public class UpdateTraceBoundsJob
extends Job {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(UpdateTraceBoundsJob.class);
    private static final String BOUNDS_FILE_NAME = "bounds";
    private final Queue<TmfTraceElement> fTraceBoundsToUpdate;

    public UpdateTraceBoundsJob(String name, Queue<TmfTraceElement> traceBoundsToUpdate) {
        super(name);
        this.fTraceBoundsToUpdate = traceBoundsToUpdate;
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.fTraceBoundsToUpdate.size());
        while (!this.fTraceBoundsToUpdate.isEmpty()) {
            subMonitor.setTaskName(this.getName());
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            TmfTraceElement tElement = this.fTraceBoundsToUpdate.poll();
            ITmfTimestamp start = tElement.getStartTime();
            ITmfTimestamp end = tElement.getEndTime();
            if (start != null && end != null) {
                subMonitor.worked(1);
                continue;
            }
            IFolder folder = tElement.getTraceSupplementaryFolder(tElement.getSupplementaryFolderPath());
            tElement.refreshSupplementaryFolder();
            File f = folder.getFile(BOUNDS_FILE_NAME).getLocation().toFile();
            UpdateTraceBoundsJob.tryReadBoundsFile(tElement, f);
            start = tElement.getStartTime();
            end = tElement.getEndTime();
            if (start == null || end == null) {
                UpdateTraceBoundsJob.extractBoundsFromTrace(tElement);
                UpdateTraceBoundsJob.tryWriteBoundsFile((IProgressMonitor)subMonitor.newChild(1), tElement, folder, f);
                continue;
            }
            subMonitor.worked(1);
        }
        return Status.OK_STATUS;
    }

    private static void extractBoundsFromTrace(TmfTraceElement traceElement) {
        block12: {
            boolean wasInitBefore;
            ITmfTrace trace = traceElement.getTrace();
            boolean bl = wasInitBefore = trace != null;
            if (!wasInitBefore) {
                trace = traceElement.instantiateTrace();
            }
            if (trace == null) {
                traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                traceElement.setEndTime(TmfTimestamp.BIG_BANG);
            } else {
                try {
                    try {
                        ITmfTimestamp start;
                        if (!wasInitBefore) {
                            trace.initTrace(traceElement.getResource(), traceElement.getResource().getLocation().toOSString(), traceElement.instantiateEvent().getClass(), traceElement.getElementPath(), traceElement.getTraceType());
                        }
                        if ((start = trace.readStart()) != null) {
                            traceElement.setStartTime(start);
                            traceElement.refreshViewer();
                            ITmfTimestamp end = trace.readEnd();
                            traceElement.setEndTime(end != null ? end : TmfTimestamp.BIG_BANG);
                            break block12;
                        }
                        traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                        traceElement.setEndTime(TmfTimestamp.BIG_BANG);
                    }
                    catch (TmfTraceException e1) {
                        traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                        traceElement.setEndTime(TmfTimestamp.BIG_BANG);
                        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"Failed to read time bounds", (Object[])new Object[]{"trace", traceElement.getName()});
                        if (!wasInitBefore) {
                            trace.dispose();
                        }
                    }
                }
                finally {
                    if (!wasInitBefore) {
                        trace.dispose();
                    }
                }
            }
        }
    }

    private static void tryWriteBoundsFile(IProgressMonitor monitor, TmfTraceElement traceElement, IFolder folder, File boundsFile) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            boundsFile.createNewFile();
            ByteBuffer writeBuffer = ByteBuffer.allocate(16);
            long writeStart = traceElement.getStartTime() != null ? traceElement.getStartTime().toNanos() : Long.MIN_VALUE;
            long writeEnd = traceElement.getEndTime() != null ? traceElement.getEndTime().toNanos() : Long.MIN_VALUE;
            writeBuffer.putLong(writeStart);
            writeBuffer.putLong(writeEnd);
            Files.write(boundsFile.toPath(), writeBuffer.array(), StandardOpenOption.WRITE);
            SubMonitor newChild = subMonitor.newChild(1);
            folder.refreshLocal(2, (IProgressMonitor)newChild);
            newChild.subTask("");
        }
        catch (IOException e) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"Failed to write time bounds to supplementary file", (Object[])new Object[]{"trace", traceElement.getName(), "supplementary file", folder.getName()});
        }
        catch (CoreException e) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"Failed to refresh supplementary file", (Object[])new Object[]{"trace", traceElement.getName(), "supplementary file", folder.getName()});
        }
    }

    private static void tryReadBoundsFile(TmfTraceElement traceElement, File boundsFile) {
        if (boundsFile.exists()) {
            try {
                byte[] bytes = Files.readAllBytes(boundsFile.toPath());
                ByteBuffer readBuffer = ByteBuffer.allocate(16);
                readBuffer.put(bytes);
                readBuffer.flip();
                long tmp = readBuffer.getLong();
                if (tmp == Long.MIN_VALUE) {
                    traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                } else {
                    traceElement.setStartTime(TmfTimestamp.fromNanos((long)tmp));
                }
                tmp = readBuffer.getLong();
                if (tmp == Long.MIN_VALUE) {
                    traceElement.setEndTime(TmfTimestamp.BIG_BANG);
                } else {
                    traceElement.setEndTime(TmfTimestamp.fromNanos((long)tmp));
                }
                traceElement.refreshViewer();
            }
            catch (IOException e) {
                TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"Failed to read time bounds", (Object[])new Object[]{"trace", traceElement.getName(), "bounds file", boundsFile.getAbsoluteFile()});
                boundsFile.delete();
            }
        }
    }
}

