/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitableURLClassLoader
extends URLClassLoader
implements ClassLoaderHierarchy {
    public VisitableURLClassLoader(ClassLoader parent, Collection<URL> urls) {
        super(urls.toArray(new URL[0]), parent);
    }

    public VisitableURLClassLoader(ClassLoader parent, ClassPath classPath) {
        super(classPath.getAsURLArray(), parent);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        URL[] urls = this.getURLs();
        visitor.visitSpec(new Spec(Arrays.asList(urls)));
        visitor.visitClassPath(urls);
        visitor.visitParent(this.getParent());
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Spec
    extends ClassLoaderSpec {
        final List<URL> classpath;

        public Spec(List<URL> classpath) {
            this.classpath = classpath;
        }

        public List<URL> getClasspath() {
            return this.classpath;
        }

        public String toString() {
            return "{url-class-loader  classpath:" + this.classpath + "}";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return this.classpath.equals(other.classpath);
        }

        public int hashCode() {
            return this.classpath.hashCode();
        }
    }
}

