/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Volume {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="DriverOpts")
    private ImmutableMap<String, String> driverOpts;
    @JsonProperty(value="Labels")
    private ImmutableMap<String, String> labels;
    @JsonProperty(value="Mountpoint")
    private String mountpoint;
    @JsonProperty(value="Scope")
    private String scope;
    @JsonProperty(value="Status")
    private ImmutableMap<String, String> status;

    private Volume() {
    }

    private Volume(Builder builder) {
        this.name = builder.name;
        this.driver = builder.driver;
        this.driverOpts = builder.driverOpts;
        this.labels = builder.labels;
        this.mountpoint = builder.mountpoint;
        this.scope = builder.scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String driver() {
        return this.driver;
    }

    public Map<String, String> driverOpts() {
        return this.driverOpts;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public String mountpoint() {
        return this.mountpoint;
    }

    public String scope() {
        return this.scope;
    }

    public Map<String, String> status() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Volume that = (Volume)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.driver, that.driver) && Objects.equals(this.driverOpts, that.driverOpts) && Objects.equals(this.labels, that.labels) && Objects.equals(this.mountpoint, that.mountpoint) && Objects.equals(this.scope, that.scope) && Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.driver, this.driverOpts, this.labels, this.mountpoint, this.scope, this.status);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("driver", (Object)this.driver).add("driverOpts", this.driverOpts).add("labels", this.labels).add("mountpoint", (Object)this.mountpoint).add("scope", (Object)this.scope).add("status", this.status).toString();
    }

    public static class Builder {
        private String name;
        private String driver;
        private ImmutableMap<String, String> driverOpts;
        private ImmutableMap<String, String> labels;
        private String mountpoint;
        private String scope;

        private Builder() {
        }

        private Builder(Volume volume) {
            this.name = volume.name;
            this.driver = volume.driver;
            this.driverOpts = volume.driverOpts;
            this.labels = volume.labels;
            this.mountpoint = volume.mountpoint;
            this.scope = volume.scope;
        }

        public Volume build() {
            return new Volume(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public Builder driverOpts(Map<String, String> driverOpts) {
            this.driverOpts = ImmutableMap.copyOf(driverOpts);
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels = ImmutableMap.copyOf(labels);
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }
    }
}

