/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.freeze.command;

import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.freeze.FreezeLayer;
import net.sourceforge.nattable.freeze.command.FreezeColumnCommand;
import net.sourceforge.nattable.freeze.command.FreezeColumnStrategy;
import net.sourceforge.nattable.freeze.command.FreezeSelectionCommand;
import net.sourceforge.nattable.freeze.command.FreezeSelectionStrategy;
import net.sourceforge.nattable.freeze.command.IFreezeCommand;
import net.sourceforge.nattable.freeze.command.IFreezeCoordinatesProvider;
import net.sourceforge.nattable.freeze.command.UnFreezeGridCommand;
import net.sourceforge.nattable.freeze.event.FreezeEvent;
import net.sourceforge.nattable.freeze.event.UnfreezeEvent;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.viewport.ViewportLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreezeCommandHandler
extends AbstractLayerCommandHandler<IFreezeCommand> {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;

    public FreezeCommandHandler(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<IFreezeCommand> getCommandClass() {
        return IFreezeCommand.class;
    }

    @Override
    public boolean doCommand(IFreezeCommand command) {
        if (command instanceof FreezeColumnCommand) {
            FreezeColumnCommand freezeColumnCommand = (FreezeColumnCommand)command;
            FreezeColumnStrategy coordinatesProvider = new FreezeColumnStrategy(this.freezeLayer, freezeColumnCommand.getColumnPosition());
            this.handleFreezeCommand(coordinatesProvider);
            return true;
        }
        if (command instanceof FreezeSelectionCommand) {
            FreezeSelectionStrategy coordinatesProvider = new FreezeSelectionStrategy(this.freezeLayer, this.viewportLayer, this.selectionLayer);
            this.handleFreezeCommand(coordinatesProvider);
            return true;
        }
        if (command instanceof UnFreezeGridCommand) {
            this.handleUnfreeze();
            return true;
        }
        return false;
    }

    protected void handleFreezeCommand(IFreezeCoordinatesProvider coordinatesProvider) {
        if (this.freezeLayer.getColumnCount() == 0 && this.freezeLayer.getRowCount() == 0) {
            PositionCoordinate topLeftPosition = coordinatesProvider.getTopLeftPosition();
            PositionCoordinate bottomRightPosition = coordinatesProvider.getBottomRightPosition();
            this.freezeLayer.setTopLeftPosition(topLeftPosition.columnPosition, topLeftPosition.rowPosition);
            this.freezeLayer.setBottomRightPosition(bottomRightPosition.columnPosition, bottomRightPosition.rowPosition);
            this.viewportLayer.setMinimumOriginPosition(bottomRightPosition.columnPosition + 1, bottomRightPosition.rowPosition + 1);
            this.viewportLayer.fireLayerEvent(new FreezeEvent(this.viewportLayer));
        }
    }

    protected void handleUnfreeze() {
        this.resetFrozenArea();
        this.viewportLayer.fireLayerEvent(new UnfreezeEvent(this.viewportLayer));
    }

    private void resetFrozenArea() {
        this.freezeLayer.setTopLeftPosition(-1, -1);
        this.freezeLayer.setBottomRightPosition(-1, -1);
        this.viewportLayer.resetOrigin();
    }
}

