/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.data.IRowDataProvider;
import net.sourceforge.nattable.data.IRowIdAccessor;
import net.sourceforge.nattable.selection.ISelectionModel;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSelectionModel<R>
implements ISelectionModel {
    private final SelectionLayer selectionLayer;
    private final IRowDataProvider<R> rowDataProvider;
    private final IRowIdAccessor<R> rowIdAccessor;
    private Map<Serializable, R> selectedRows;
    private Rectangle lastSelectedRange;
    private Set<Serializable> lastSelectedRowIds;
    private final ReadWriteLock selectionsLock;

    public RowSelectionModel(SelectionLayer selectionLayer, IRowDataProvider<R> rowDataProvider, IRowIdAccessor<R> rowIdAccessor) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.selectedRows = new HashMap<Serializable, R>();
        this.selectionsLock = new ReentrantReadWriteLock();
    }

    @Override
    public void clearSelection() {
        this.selectionsLock.writeLock().lock();
        try {
            this.selectedRows.clear();
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isColumnPositionSelected(int columnPosition) {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = !this.selectedRows.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public int[] getSelectedColumns() {
        if (!this.isEmpty()) {
            int columnCount;
            this.selectionsLock.readLock().lock();
            try {
                columnCount = this.selectionLayer.getColumnCount();
            }
            finally {
                this.selectionsLock.readLock().unlock();
            }
            int[] columns = new int[columnCount];
            int i = 0;
            while (i < columnCount) {
                columns[i] = i;
                ++i;
            }
            return columns;
        }
        return new int[0];
    }

    @Override
    public void addSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            R rowObject = this.getRowObjectByPosition(rowPosition);
            if (rowObject != null) {
                Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
                this.selectedRows.put(rowId, rowObject);
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void addSelection(Rectangle range) {
        this.selectionsLock.writeLock().lock();
        try {
            if (range == this.lastSelectedRange && this.lastSelectedRowIds != null) {
                for (Serializable rowId : this.lastSelectedRowIds) {
                    this.selectedRows.remove(rowId);
                }
            }
            HashMap<Serializable, R> rowsToSelect = new HashMap<Serializable, R>();
            int rowPosition = range.y;
            while (rowPosition < range.y + range.height) {
                R rowObject = this.getRowObjectByPosition(rowPosition);
                if (rowObject != null) {
                    Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
                    rowsToSelect.put(rowId, rowObject);
                }
                ++rowPosition;
            }
            this.selectedRows.putAll(rowsToSelect);
            this.lastSelectedRowIds = range == this.lastSelectedRange ? rowsToSelect.keySet() : null;
            this.lastSelectedRange = range;
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public int[] getFullySelectedColumns(int fullySelectedColumnRowCount) {
        this.selectionsLock.readLock().lock();
        try {
            if (this.isColumnFullySelected(0, fullySelectedColumnRowCount)) {
                int[] nArray = this.getSelectedColumns();
                return nArray;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return new int[0];
    }

    @Override
    public int[] getFullySelectedRows(int rowWidth) {
        this.selectionsLock.readLock().lock();
        try {
            int selectedRowCount = this.selectedRows.size();
            int[] selectedRowPositions = new int[selectedRowCount];
            int i = 0;
            for (Serializable rowId : this.selectedRows.keySet()) {
                selectedRowPositions[i] = this.getRowPositionById(rowId);
                ++i;
            }
            int[] nArray = selectedRowPositions;
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public int getSelectedRowCount() {
        this.selectionsLock.readLock().lock();
        try {
            int n = this.selectedRows.size();
            return n;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public Set<Range> getSelectedRows() {
        HashSet<Range> selectedRowRanges = new HashSet<Range>();
        this.selectionsLock.readLock().lock();
        try {
            for (Serializable rowId : this.selectedRows.keySet()) {
                int rowPosition = this.getRowPositionById(rowId);
                selectedRowRanges.add(new Range(rowPosition, rowPosition + 1));
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return selectedRowRanges;
    }

    @Override
    public List<Rectangle> getSelections() {
        ArrayList<Rectangle> selectionRectangles = new ArrayList<Rectangle>();
        this.selectionsLock.readLock().lock();
        try {
            int width = this.selectionLayer.getColumnCount();
            for (Serializable rowId : this.selectedRows.keySet()) {
                int rowPosition = this.getRowPositionById(rowId);
                selectionRectangles.add(new Rectangle(0, rowPosition, width, 1));
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return selectionRectangles;
    }

    @Override
    public boolean isCellPositionSelected(int columnPosition, int rowPosition) {
        return this.isRowPositionSelected(rowPosition);
    }

    @Override
    public boolean isColumnFullySelected(int columnPosition, int fullySelectedColumnRowCount) {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = this.selectedRows.size() == fullySelectedColumnRowCount;
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = this.selectedRows.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isRowFullySelected(int rowPosition, int rowWidth) {
        return this.isRowPositionSelected(rowPosition);
    }

    @Override
    public boolean isRowPositionSelected(int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            boolean bl = this.selectedRows.containsKey(rowId);
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public void removeSelection(Rectangle removedSelection) {
        this.selectionsLock.writeLock().lock();
        try {
            int rowPosition = removedSelection.y;
            while (rowPosition < removedSelection.y + removedSelection.height) {
                this.removeSelection(0, rowPosition);
                ++rowPosition;
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void removeSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            this.selectedRows.remove(rowId);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    private Serializable getRowIdByPosition(int rowPosition) {
        R rowObject = this.getRowObjectByPosition(rowPosition);
        if (rowObject != null) {
            Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
            return rowId;
        }
        return null;
    }

    private R getRowObjectByPosition(int rowPosition) {
        block6: {
            this.selectionsLock.readLock().lock();
            try {
                R r;
                int rowIndex = this.selectionLayer.getRowIndexByPosition(rowPosition);
                if (rowIndex < 0) break block6;
                try {
                    R rowObject;
                    r = rowObject = this.rowDataProvider.getRowObject(rowIndex);
                }
                catch (Exception exception) {
                    break block6;
                }
                return r;
            }
            finally {
                this.selectionsLock.readLock().unlock();
            }
        }
        return null;
    }

    private int getRowPositionById(Serializable rowId) {
        this.selectionsLock.readLock().lock();
        try {
            int rowPosition;
            R rowObject = this.selectedRows.get(rowId);
            int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
            int n = rowPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
            return n;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }
}

