/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.BufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkDecoder;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkEncoder;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkListener;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPReader {
    static final Logger LOGGER = Logger.getLogger(HTTPReader.class);
    public static final int INIT_NUM_HEADERS = 50;
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final int EOF = -1;
    private PushbackInputStream fIn;
    private long fLastReadTime = 0L;
    protected int fLastByte = -1;
    public static final int INIT_NUM_TRAILERS = 2;

    protected HTTPReader(InputStream inputStream) {
        this.fIn = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 1);
    }

    protected InputStream getInputStream() {
        return this.fIn;
    }

    protected final long getLastReadTime() {
        return this.fLastReadTime;
    }

    protected final int getLastByte() {
        return this.fLastByte;
    }

    /*
     * Unable to fully structure code
     */
    private int getAvailableInput(long var1_1) throws IOException, TimeoutException {
        while (true) {
            try {
                var3_2 = this.fIn.read();
            }
            catch (SocketTimeoutException v0) {
                if (var1_1 <= 0L) continue;
                if (this.fLastReadTime == 0L) {
                    this.fLastReadTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.fLastReadTime > var1_1) ** break;
                continue;
                this.fLastReadTime = System.currentTimeMillis();
                throw new TimeoutException("HTTPReader.getAvailableInput");
            }
            break;
        }
        this.fLastReadTime = System.currentTimeMillis();
        return var3_2;
    }

    protected final boolean nextByte(long l, OutputStream outputStream) throws IOException, TimeoutException {
        this.fLastByte = this.getAvailableInput(l);
        if (this.fLastByte != -1) {
            outputStream.write(this.fLastByte);
            return true;
        }
        return false;
    }

    private final boolean hasContinuedLine(long l) throws IOException, TimeoutException {
        if (this.fLastByte != 10) {
            return false;
        }
        int n = this.getAvailableInput(l);
        this.fIn.unread(n);
        return n == 32 || n == 9;
    }

    protected final int readBytes(long l, OutputStream outputStream, int n) throws IOException, TimeoutException {
        int n2 = 0;
        while (n2 < n) {
            if (!this.nextByte(l, outputStream)) break;
            ++n2;
        }
        return n2;
    }

    protected List<IHTTPHeader> readChunkedMessageTrailers(long l, HTTPMessageBuffer hTTPMessageBuffer) throws IOException, TimeoutException {
        HeaderInBuffer headerInBuffer;
        ArrayList<HeaderInBuffer> arrayList = null;
        while ((headerInBuffer = this.readHeader(l, hTTPMessageBuffer)) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<HeaderInBuffer>(2);
            }
            arrayList.add(headerInBuffer);
        }
        return arrayList;
    }

    protected HeaderInBuffer readHeader(long l, HTTPMessageBuffer hTTPMessageBuffer) throws IOException, TimeoutException {
        BufferRange bufferRange = new BufferRange();
        this.readNextToken(l, hTTPMessageBuffer, bufferRange, ':');
        if (this.fLastByte == -1 || this.fLastByte == 10) {
            return null;
        }
        if (this.fLastByte != 58) {
            throw new IOException("Unexpected char (" + this.fLastByte + ".) Expected was (':')");
        }
        this.skipSpaces(l, hTTPMessageBuffer);
        BufferRange bufferRange2 = new BufferRange();
        this.readNextToken(l, hTTPMessageBuffer, bufferRange2);
        while (this.hasContinuedLine(l)) {
            this.readContinuedLine(l, hTTPMessageBuffer, bufferRange2);
        }
        HeaderInBuffer headerInBuffer = new HeaderInBuffer();
        headerInBuffer.init(hTTPMessageBuffer, bufferRange, bufferRange2);
        return headerInBuffer;
    }

    private final int readContinuedLine(long l, HTTPMessageBuffer hTTPMessageBuffer, IBufferRange iBufferRange) throws IOException, TimeoutException {
        int n = hTTPMessageBuffer.getLength();
        boolean bl = false;
        boolean bl2 = false;
        while (this.fLastByte != -1) {
            this.nextByte(l, hTTPMessageBuffer);
            if (this.fLastByte == 13) {
                bl = true;
                continue;
            }
            if (this.fLastByte == 10 && bl) {
                bl2 = true;
                break;
            }
            bl = false;
        }
        int n2 = hTTPMessageBuffer.getLength() - n;
        if (bl2) {
            n2 -= 2;
        }
        iBufferRange.setLength(iBufferRange.getLength() + n2);
        return this.fLastByte;
    }

    protected final void skipSpaceCRAndLFs(long l) throws IOException, TimeoutException {
        this.fLastByte = this.getAvailableInput(l);
        while (this.fLastByte == 32 || this.fLastByte == 13 || this.fLastByte == 10) {
            this.fLastByte = SocketTimeoutRetryInputStream.read(this.fIn);
        }
        this.fIn.unread(this.fLastByte);
    }

    protected final void skipSpaces(long l, OutputStream outputStream) throws IOException, TimeoutException {
        this.fLastByte = this.getAvailableInput(l);
        while (this.fLastByte == 32) {
            outputStream.write(this.fLastByte);
            this.fLastByte = SocketTimeoutRetryInputStream.read(this.fIn);
        }
        this.fIn.unread(this.fLastByte);
    }

    protected final int readNextToken(long l, HTTPMessageBuffer hTTPMessageBuffer, IBufferRange iBufferRange) throws IOException, TimeoutException {
        return this.readNextToken(l, hTTPMessageBuffer, iBufferRange, '\u0000');
    }

    protected final int readNextToken(long l, HTTPMessageBuffer hTTPMessageBuffer, IBufferRange iBufferRange, char c) throws IOException, TimeoutException {
        int n = hTTPMessageBuffer.getLength();
        this.nextByte(l, hTTPMessageBuffer);
        int n2 = 0;
        boolean bl = false;
        while (this.fLastByte != -1) {
            if (c != '\u0000' && this.fLastByte == c) break;
            if (this.fLastByte == 13) {
                bl = true;
            } else {
                if (this.fLastByte == 10 && bl) {
                    --n2;
                    break;
                }
                bl = false;
            }
            this.nextByte(l, hTTPMessageBuffer);
            ++n2;
        }
        if (n2 > 0) {
            iBufferRange.setStart(n);
            iBufferRange.setLength(n2);
        }
        return this.fLastByte;
    }

    protected void readCRLF(long l, OutputStream outputStream) throws IOException, TimeoutException {
        this.nextByte(l, outputStream);
        if (this.fLastByte != 13) {
            throw new IOException("Unexpected char (" + this.fLastByte + ".) Expected was (" + Integer.toString(13) + ")");
        }
        this.nextByte(l, outputStream);
        if (this.fLastByte != 10) {
            throw new IOException("Unexpected char (" + this.fLastByte + ".) Expected was (" + Integer.toString(10) + ")");
        }
    }

    protected final String readNextToken(long l, OutputStream outputStream) throws IOException, TimeoutException {
        return this.readNextToken(l, outputStream, '\u0000');
    }

    protected final String readNextToken(long l, OutputStream outputStream, char c) throws IOException, TimeoutException {
        this.nextByte(l, outputStream);
        if (this.fLastByte == -1) {
            return null;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.fLastByte != -1) {
            if (c != '\u0000' && this.fLastByte == c) break;
            if (this.fLastByte == 13) {
                bl = true;
            } else {
                if (this.fLastByte == 10 && bl) break;
                bl = false;
                stringBuffer.append((char)this.fLastByte);
            }
            this.nextByte(l, outputStream);
        }
        return stringBuffer.toString();
    }

    public int readChunkedMessageBody(long l, OutputStream outputStream) throws IOException, TimeoutException {
        ChunkDecoder chunkDecoder = new ChunkDecoder(this.fIn);
        final ChunkEncoder chunkEncoder = new ChunkEncoder(outputStream);
        chunkDecoder.setChunkListener(new ChunkListener(){

            public void newChankRead(int n, int n2) {
                try {
                    chunkEncoder.setMaxChunkSize(n2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        try {
            int n;
            int n2 = 0;
            while ((n = chunkDecoder.read(l)) != -1) {
                chunkEncoder.write(n);
                ++n2;
            }
            int n3 = n2;
            return n3;
        }
        finally {
            chunkDecoder.close();
            chunkEncoder.close();
        }
    }
}

