/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.internal.win32.AccessibleHilighter;
import org.eclipse.actf.util.win32.IIntervalExec;
import org.eclipse.actf.util.win32.OverlayWindow;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class HighlightComposite
extends Composite
implements IIntervalExec {
    private static final int BORDER_WIDTH = 3;
    private static HighlightComposite instance;
    private StyledText text;
    private Display display = this.getDisplay();
    private int flashingIndex = -1;
    private static int suppressRefCount;
    private static boolean needRedraw;
    private static final int[][] FLASHING_COLORS;
    private static final int MESSAGE_COLOR = 28;
    private static final int MESSAGE_BACK = 29;

    static {
        suppressRefCount = 0;
        needRedraw = true;
        FLASHING_COLORS = new int[][]{{7, 250}, {5, 250}, {7, 250}, {5, 250}, {7, 250}, {5, 250}, {7, 1000}};
    }

    private HighlightComposite(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 3;
        gridLayout.marginWidth = 3;
        this.setLayout((Layout)gridLayout);
        this.text = new StyledText((Composite)this, 0);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.setBackground(composite.getBackground());
    }

    private void show(Rectangle rectangle, String string) {
        if (-1 != this.flashingIndex) {
            needRedraw = true;
        }
        this.flashingIndex = 0;
        if (string != null) {
            this.text.setText(string);
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = this.text.getCharCount();
            styleRange.foreground = this.display.getSystemColor(28);
            styleRange.background = this.display.getSystemColor(29);
            this.text.setStyleRange(styleRange);
        }
        HighlightComposite.getOverlayWindow().getComposite().moveAbove(null);
        this.moveAbove(null);
        this.setBounds(rectangle.x, rectangle.y, Math.max(3, rectangle.width), Math.max(3, rectangle.height));
        this.setVisible(true);
    }

    public int exec() {
        if (-1 != this.flashingIndex) {
            if (this.flashingIndex < FLASHING_COLORS.length) {
                this.setBackground(this.display.getSystemColor(FLASHING_COLORS[this.flashingIndex][0]));
                return FLASHING_COLORS[this.flashingIndex++][1];
            }
            this.flashingIndex = -1;
            this.setVisible(false);
            if (needRedraw) {
                needRedraw = false;
                HighlightComposite.getOverlayWindow().getComposite().redraw();
            }
        }
        return 0;
    }

    public static void flashRectangle(Rectangle rectangle) {
        try {
            if (rectangle != null && suppressRefCount == 0) {
                if (OverlayWindow.getVisible()) {
                    OverlayWindow overlayWindow = HighlightComposite.getOverlayWindow();
                    if (instance == null) {
                        instance = new HighlightComposite(overlayWindow.getComposite(), 0);
                    }
                    instance.show(rectangle, "");
                    overlayWindow.run();
                } else {
                    AccessibleHilighter.flashRectangle(rectangle);
                }
            }
        }
        catch (Exception exception) {}
    }

    public static int updateSuppressCount(int n) {
        return suppressRefCount += n;
    }

    public static void show(boolean bl) {
        if (instance != null) {
            instance.setVisible(bl);
        }
    }

    private static OverlayWindow getOverlayWindow() {
        return OverlayWindow.getInstance(0, true);
    }

    public static void initOverlayWindow() {
        HighlightComposite.getOverlayWindow();
    }
}

