/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.birt.chart.model.IChartObject;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Canvas;

public abstract class PreviewPainterBase<CX extends IChartWizardContext<?>>
implements IChartPreviewPainter {
    private static final int PAINT_DELAY = 200;
    private Timer fPaintTimer = null;
    protected Canvas preview = null;
    protected IChartObject chart = null;
    private static boolean enableProcessor = true;
    private static boolean isLivePreview = false;
    protected CX wizardContext;

    protected PreviewPainterBase(CX wizardContext) {
        this.wizardContext = wizardContext;
    }

    @Override
    public void dispose() {
        PreviewPainterBase.activateLivePreview(false);
        if (this.fPaintTimer != null) {
            this.fPaintTimer.cancel();
            this.fPaintTimer = null;
        }
    }

    protected void doRenderModel(IChartObject object) {
        if (!this.isDisposedPreviewCanvas()) {
            this.clearPreviewCanvas();
            this.repaintChartInTimer();
        }
    }

    @Override
    public void renderModel(IChartObject cm) {
        if (cm == null) {
            return;
        }
        this.chart = cm.copyInstance();
        this.doRenderModel(this.chart);
    }

    @Override
    public void setPreview(Canvas previewCanvas) {
        this.preview = previewCanvas;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.repaintChartInTimer();
    }

    protected void repaintChartInTimer() {
        if (this.fPaintTimer != null) {
            this.fPaintTimer.cancel();
        }
        this.fPaintTimer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                PreviewPainterBase.this.paintChart();
            }
        };
        this.fPaintTimer.schedule(task, 200L);
    }

    protected abstract void paintChart();

    protected void clearPreviewCanvas() {
    }

    protected boolean isDisposedPreviewCanvas() {
        return this.preview == null || this.preview.isDisposed();
    }

    protected boolean isLivePreviewEnabled() {
        return true;
    }

    protected void ignoreNotifications(boolean bIgnoreNotifications) {
        ChartAdapter.ignoreNotifications(bIgnoreNotifications);
    }

    public static boolean isLivePreviewActive() {
        return isLivePreview;
    }

    public static void activateLivePreview(boolean canLive) {
        isLivePreview = canLive;
    }

    public static void enableProcessor(boolean isEnabled) {
        enableProcessor = isEnabled;
    }

    public static boolean isProcessorEnabled() {
        return enableProcessor;
    }
}

