/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.util.Map;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VariableParameter
implements IMethodParameter {
    private String name;
    private String dataType;
    private Object value;
    private String stringValue;

    public VariableParameter(String name, String dataType) {
        assert (name != null && dataType != null);
        this.name = name;
        this.dataType = dataType;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Element createElement(Document doc) {
        Element ele = doc.createElement("VariableParameter");
        ele.setAttribute("name", this.name);
        ele.setAttribute("value", this.stringValue);
        ele.setAttribute("type", this.getDataType());
        return ele;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableParameter other = (VariableParameter)obj;
        if (!this.dataType.equals(other.dataType)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    public Object getTargetValue() {
        return this.value;
    }

    @Override
    public void prepareValue(Map<String, Object> paramValues, ClassLoader pojoClassLoader) throws OdaException {
        if (!paramValues.containsKey(this.getName())) {
            throw new OdaException(Messages.getString("MethodSource.MissingPrameterValue", this.getName()));
        }
        this.value = paramValues.get(this.getName());
    }

    @Override
    public void setDataType(String type) {
        this.dataType = type;
    }

    @Override
    public void setStringValue(String value) {
        this.stringValue = value;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }
}

