/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerComposite;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutData;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Cursor;

public class ColumnDragTracker
extends TableDragGuideTracker {
    private static final String RESIZE_COLUMN_TRANS_LABEL = Messages.getString((String)"ColumnDragTracker.ResizeColumn");
    private static final String PREFIX_LABEL = Messages.getString((String)"ColumnDragTracker.Show.Label");

    public ColumnDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZEWE);
    }

    protected Cursor getDefaultCursor() {
        if (this.isCloneActive()) {
            return Cursors.SIZEWE;
        }
        return super.getDefaultCursor();
    }

    @Override
    protected void resize() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getMouseTrueValueX();
        part.getTableAdapter().transStar(RESIZE_COLUMN_TRANS_LABEL);
        if (this.isresizeMultipleColumn() && this.isCtrlDown()) {
            List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
            boolean resizeTable = false;
            int width = 0;
            int i = 0;
            while (i < list.size()) {
                int tempValue = value;
                Object model = ((EditPart)list.get(i)).getModel();
                ColumnHandleAdapter adapter = HandleAdapterFactory.getInstance().getColumnHandleAdapter(model);
                int start = adapter.getColumnNumber();
                int end = start + 1;
                int ori = TableUtil.caleVisualWidth(part, model);
                int adjustWidth = TableUtil.caleVisualWidth(part, part.getColumn(this.getStart())) + value;
                if (this.getStart() != start) {
                    tempValue = adjustWidth - ori;
                }
                if (start == part.getColumnCount()) {
                    end = start;
                    resizeTable = true;
                } else {
                    width += this.getTrueValue(tempValue, start, end);
                }
                this.resizeColumn(tempValue, start, end);
                ++i;
            }
            if (resizeTable) {
                Dimension size = part.getTableAdapter().getSize();
                try {
                    part.getTableAdapter().setSize(new Dimension(size.width + width, -1));
                }
                catch (SemanticException e) {
                    part.getTableAdapter().rollBack();
                    ExceptionHandler.handle(e);
                }
            }
        } else {
            this.resizeColumn(value, this.getStart(), this.getEnd());
        }
        part.getTableAdapter().transEnd();
    }

    private void resizeColumn(int value, int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        if (start != end) {
            value = this.getTrueValue(value, start, end);
            part.resizeColumn(start, end, value, !this.isCtrlDown());
        } else {
            Dimension dimension = this.getDragWidth(start, end);
            if (value < dimension.width) {
                value = dimension.width;
            }
            TableHandleAdapter adp = HandleAdapterFactory.getInstance().getTableHandleAdapter(part.getModel());
            Dimension dm = adp.calculateSize();
            dm.width += value;
            dm.height = -1;
            try {
                adp.ajustSize(dm);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void resizeFixColumn(int value, int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        value = this.getTrueValue(value, start, end);
        Object startColumn = part.getColumn(start);
        if (!(startColumn instanceof ColumnHandle)) {
            return;
        }
        Object endColumn = part.getColumn(end);
        if (!(endColumn instanceof ColumnHandle)) {
            return;
        }
        int startWidth = 0;
        int endWidth = 0;
        startWidth = TableUtil.caleVisualWidth(part, startColumn);
        endWidth = TableUtil.caleVisualWidth(part, endColumn);
        try {
            MetricUtility.updateDimension((DimensionHandle)((ColumnHandle)startColumn).getWidth(), (double)(startWidth + value));
            if (!this.isCtrlDown() && start != end) {
                MetricUtility.updateDimension((DimensionHandle)((ColumnHandle)startColumn).getWidth(), (double)(endWidth - value));
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private boolean isresizeMultipleColumn() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
        if (list.size() < 2) {
            return false;
        }
        Object first = ((EditPart)list.get(0)).getModel();
        if (!(first instanceof ColumnHandle) || !((ColumnHandle)first).getContainer().equals(part.getModel())) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            Object model = ((EditPart)list.get(i)).getModel();
            if (model.equals(part.getColumn(this.getStart()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = ((TableEditPart)this.getSourceEditPart()).getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().x - this.getStartLocation().x;
        value = this.getTrueValueAbsolute(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(value + p.x, bounds.y + insets.top, 2, bounds.height - (insets.top + insets.bottom));
    }

    @Override
    protected Dimension getDragWidth(int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        if (this.isCtrlDown()) {
            Dimension retValue = new Dimension(part.getMinWidth(start) - this.getColumnWidth(start), Integer.MAX_VALUE);
            return retValue;
        }
        if (this.getStart() == this.getEnd()) {
            return new Dimension(part.getMinWidth(this.getStart()) - this.getColumnWidth(this.getStart()), Integer.MAX_VALUE);
        }
        return new Dimension(part.getMinWidth(this.getStart()) - this.getColumnWidth(this.getStart()), this.getColumnWidth(this.getEnd()) - part.getMinWidth(this.getEnd()));
    }

    protected void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    protected int getColumnWidth(int columnNumber) {
        Object column = this.getTableEditPart().getColumn(columnNumber);
        if (column == null) {
            return HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableEditPart().getModel()).getDefaultWidth(columnNumber);
        }
        return this.getColumnWidth(column);
    }

    protected int getColumnWidth(Object column) {
        return TableUtil.caleVisualWidth(this.getTableEditPart(), column);
    }

    protected TableEditPart getTableEditPart() {
        return (TableEditPart)this.getSourceEditPart();
    }

    @Override
    protected String getInfomation() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        return this.getShowLabel(TableUtil.caleVisualWidth(part, part.getColumn(this.getStart())));
    }

    private String getShowLabel(int pix) {
        String unit = this.getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        return String.valueOf(PREFIX_LABEL) + " " + this.getShowValue(showValue) + " " + ColumnDragTracker.getUnitDisplayName(unit) + " (" + pix + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected boolean handleDragInProgress() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        boolean bool = super.handleDragInProgress();
        int value = this.getTrueValue(this.getMouseTrueValueX());
        int adjustWidth = TableUtil.caleVisualWidth(part, part.getColumn(this.getStart())) + value;
        this.updateInfomation(this.getShowLabel(adjustWidth));
        return bool;
    }

    @Override
    protected void fitResize() {
        ArrayList<Integer> exclusion = new ArrayList<Integer>();
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getMouseTrueValueX();
        part.getTableAdapter().transStar(RESIZE_COLUMN_TRANS_LABEL);
        int width = 0;
        if (this.isresizeMultipleColumn() && this.isCtrlDown()) {
            List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
            int i = 0;
            while (i < list.size()) {
                int tempValue = value;
                Object model = ((EditPart)list.get(i)).getModel();
                ColumnHandleAdapter adapter = HandleAdapterFactory.getInstance().getColumnHandleAdapter(model);
                int start = adapter.getColumnNumber();
                exclusion.add(start);
                int end = start + 1;
                int ori = TableUtil.caleVisualWidth(part, model);
                int adjustWidth = TableUtil.caleVisualWidth(part, part.getColumn(this.getStart())) + value;
                if (this.getStart() != start) {
                    tempValue = adjustWidth - ori;
                }
                if (start == part.getColumnCount()) {
                    end = start;
                }
                width += this.getTrueValue(tempValue, start, end);
                this.resizeFixColumn(tempValue, start, end);
                ++i;
            }
        } else {
            exclusion.add(this.getStart());
            width += this.getTrueValue(value, this.getStart(), this.getEnd());
            this.resizeFixColumn(value, this.getStart(), this.getEnd());
        }
        if (!this.isCtrlDown()) {
            exclusion.add(this.getEnd());
            if (this.getStart() != this.getEnd()) {
                width = 0;
            }
        }
        Dimension tableSize = part.getFigure().getSize();
        try {
            ReportItemHandle handle = part.getTableAdapter().getReportItemHandle();
            double tbWidth = this.converPixToDefaultUnit(tableSize.width + width);
            this.setDimensionValue(handle, tbWidth);
        }
        catch (SemanticException e) {
            part.getTableAdapter().rollBack();
            ExceptionHandler.handle(e);
        }
        this.adjustOthersColumn(exclusion);
        part.getTableAdapter().transEnd();
    }

    private void setDimensionValue(ReportItemHandle handle, double value) throws SemanticException {
        DimensionValue dimensionValue = new DimensionValue(value, this.getDefaultUnits());
        handle.getWidth().setValue((Object)dimensionValue);
    }

    private void adjustOthersColumn(List exclusion) {
        AbstractTableEditPart part = this.getAbstractTableEditPart();
        TableLayout.WorkingData data = this.getTableWorkingData();
        TableLayoutData.ColumnData[] datas = data.columnWidths;
        if (datas == null) {
            return;
        }
        int i = 0;
        while (i < datas.length) {
            if (!exclusion.contains(datas[i].columnNumber)) {
                ITableLayoutOwner.DimensionInfomation dim = part.getColumnWidth(datas[i].columnNumber);
                if ("%".equals(dim.getUnits())) {
                    this.resizeFixColumn(0, datas[i].columnNumber, 1);
                } else if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                    this.resizeFixColumn(0, datas[i].columnNumber, datas[i].columnNumber);
                }
            }
            ++i;
        }
    }

    @Override
    protected EditorRulerComposite.DragGuideInfo createDragGuideInfo() {
        int value = this.getTrueValue(this.getMouseTrueValueX());
        Point p = this.getStartLocation().getCopy();
        this.getAbstractTableEditPart().getFigure().translateToRelative((Translatable)p);
        EditorRulerComposite.DragGuideInfo info = new EditorRulerComposite.DragGuideInfo(true, value += p.x);
        return info;
    }
}

