/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.stsmigration;

import java.lang.reflect.Field;
import org.eclipse.buildship.stsmigration.StsMigrationState;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public final class StsMigrationPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.buildship.stsmigration";
    private static final String STS_PLUGIN_ID = "org.springsource.ide.eclipse.gradle.core";
    private static final String NOTIFICATION_MUTED_PROPERTY = "notification.muted";
    private static StsMigrationPlugin plugin;
    private static InternalStsMigrationState stsMigrationState;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        stsMigrationState = new InternalStsMigrationState();
    }

    public void stop(BundleContext context) throws Exception {
        stsMigrationState = null;
        plugin = null;
        super.stop(context);
    }

    public static StsMigrationPlugin getInstance() {
        return plugin;
    }

    public static StsMigrationState getStsMigrationState() {
        return stsMigrationState;
    }

    private static final class InternalStsMigrationState
    implements StsMigrationState {
        private InternalStsMigrationState() {
        }

        @Override
        public boolean isStsPluginInstalled() {
            BundleContext bundleContext = StsMigrationPlugin.getInstance().getBundle().getBundleContext();
            for (Bundle bundle : bundleContext.getBundles()) {
                if (!StsMigrationPlugin.STS_PLUGIN_ID.equals(bundle.getSymbolicName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isNotificationMuted() {
            return this.getConfigurationScope().getNode(StsMigrationPlugin.PLUGIN_ID).getBoolean(StsMigrationPlugin.NOTIFICATION_MUTED_PROPERTY, false);
        }

        @Override
        public void setNotificationMuted(boolean muted) {
            IEclipsePreferences node = this.getConfigurationScope().getNode(StsMigrationPlugin.PLUGIN_ID);
            node.putBoolean(StsMigrationPlugin.NOTIFICATION_MUTED_PROPERTY, muted);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }

        private ConfigurationScope getConfigurationScope() {
            try {
                Field field = ConfigurationScope.class.getField("INSTANCE");
                return (ConfigurationScope)field.get(null);
            }
            catch (Exception e1) {
                try {
                    return (ConfigurationScope)ConfigurationScope.class.newInstance();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }
}

