/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesView;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

abstract class BaseViewer
extends TreeViewer {
    protected TreeColumn nameColumn;
    protected TreeColumn locationColumn;
    protected TreeColumn sizeColumn;
    protected TreeColumn modifiedColumn;
    protected TreeColumn typeColumn;
    private static final int NUM_COLUMNS = 7;
    int[] column_sort_order = new int[7];
    private ExecutablesView executablesView;

    public BaseViewer(ExecutablesView view, Composite parent, int style) {
        super(parent, style);
        this.executablesView = view;
        int i = 0;
        while (i < 7) {
            this.column_sort_order[i] = ExecutablesView.ASCENDING;
            ++i;
        }
    }

    public ExecutablesView getExecutablesView() {
        return this.executablesView;
    }

    protected void packColumns() {
        TreeColumn[] columns;
        TreeColumn[] treeColumnArray = columns = this.getTree().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (treeColumn.getWidth() > 0) {
                treeColumn.pack();
                treeColumn.setWidth(treeColumn.getWidth() + 24);
            }
            ++n2;
        }
    }

    protected void saveColumnSettings(Preferences preferences) {
        Tree tree = this.getTree();
        StringBuilder columnOrder = new StringBuilder();
        int[] nArray = tree.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            columnOrder.append(",");
            columnOrder.append(Integer.toString(index));
            ++n2;
        }
        columnOrder.deleteCharAt(0);
        preferences.setValue(this.getColumnOrderKey(), columnOrder.toString());
        TreeColumn sortedColumn = tree.getSortColumn();
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (sortedColumn.equals(tree.getColumn(i))) {
                preferences.setValue(this.getSortedColumnIndexKey(), i);
                preferences.setValue(this.getSortedColumnDirectionKey(), tree.getSortDirection());
                break;
            }
            ++i;
        }
        String visibleColumns = "";
        int i2 = 0;
        while (i2 < tree.getColumnCount()) {
            visibleColumns = tree.getColumn(i2).getWidth() > 0 ? String.valueOf(visibleColumns) + ",1" : String.valueOf(visibleColumns) + ",0";
            ++i2;
        }
        visibleColumns = visibleColumns.substring(1);
        preferences.setValue(this.getVisibleColumnsKey(), visibleColumns);
    }

    protected void restoreColumnSettings(Preferences preferences) {
        Tree tree = this.getTree();
        String columnOrder = preferences.getString(this.getColumnOrderKey());
        if (columnOrder.length() > 0) {
            String[] columns = columnOrder.split(",");
            int[] columnNumbers = new int[columns.length];
            int i = 0;
            while (i < columns.length) {
                columnNumbers[i] = Integer.parseInt(columns[i]);
                ++i;
            }
            tree.setColumnOrder(columnNumbers);
        }
        int sortedColumnIndex = preferences.getInt(this.getSortedColumnIndexKey());
        int sortedColumnDirection = preferences.getInt(this.getSortedColumnDirectionKey());
        tree.setSortColumn(tree.getColumn(sortedColumnIndex));
        tree.setSortDirection(sortedColumnDirection == 0 ? 128 : sortedColumnDirection);
        this.setComparator(this.getViewerComparator(sortedColumnIndex));
        this.column_sort_order[sortedColumnIndex] = sortedColumnDirection == 128 ? ExecutablesView.ASCENDING : ExecutablesView.DESCENDING;
        String visibleColumns = preferences.getString(this.getVisibleColumnsKey());
        if (visibleColumns.length() <= 0) {
            visibleColumns = this.getDefaultVisibleColumnsValue();
        }
        String[] columns = visibleColumns.split(",");
        int i = 0;
        while (i < columns.length) {
            if (columns[i].equals("0")) {
                tree.getColumn(i).setWidth(0);
            }
            ++i;
        }
    }

    protected abstract ViewerComparator getViewerComparator(int var1);

    protected abstract String getColumnOrderKey();

    protected abstract String getSortedColumnIndexKey();

    protected abstract String getSortedColumnDirectionKey();

    protected abstract String getVisibleColumnsKey();

    protected abstract String getDefaultVisibleColumnsValue();

    class ColumnSelectionAdapter
    extends SelectionAdapter {
        private int selector;

        public ColumnSelectionAdapter(int selector) {
            this.selector = selector;
        }

        public void widgetSelected(SelectionEvent e) {
            BaseViewer.this.setComparator(BaseViewer.this.getViewerComparator(this.selector));
            BaseViewer.this.getTree().setSortColumn((TreeColumn)e.getSource());
            BaseViewer.this.getTree().setSortDirection(BaseViewer.this.column_sort_order[this.selector] == ExecutablesView.ASCENDING ? 128 : 1024);
            int n = this.selector;
            BaseViewer.this.column_sort_order[n] = BaseViewer.this.column_sort_order[n] * -1;
        }
    }
}

