/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.internal.security.bundle.OM;
import org.eclipse.emf.cdo.security.FilterPermission;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.impl.PermissionImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterPermissionImpl
extends PermissionImpl
implements FilterPermission {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, FilterPermissionImpl.class);

    protected FilterPermissionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SecurityPackage.Literals.FILTER_PERMISSION;
    }

    @Override
    public EList<PermissionFilter> getFilters() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, true);
    }

    @Override
    public boolean isApplicable(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext) {
        if (TRACER.isEnabled()) {
            TRACER.format("Checking {0} permission for {1}", new Object[]{this.getAccess(), revision});
        }
        for (PermissionFilter filter : this.getFilters()) {
            try {
                if (filter.isApplicable(revision, revisionProvider, securityContext, 1)) continue;
                return false;
            }
            catch (Exception ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace((Throwable)ex);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isImpacted(PermissionImpl.CommitImpactContext context) {
        for (PermissionFilter filter : this.getFilters()) {
            if (!filter.isImpacted(context)) continue;
            return true;
        }
        return false;
    }
}

