/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.efacet.ocl.core.internal;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.efacet.ocl.core.internal.Activator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.SendSignalAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFacetOCLEnvironment
extends EcoreEnvironment {
    private static final boolean DEBUG_STATUS = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    public static final String ANNOT_ENVIRONMENT = "EFacetOCLEnvironment";
    private final IFacetManager facetManager;

    public EFacetOCLEnvironment(EPackage.Registry registry, EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory, IFacetManager facetManager) {
        super(registry);
        this.facetManager = facetManager;
        this.setFactory(factory);
    }

    public EFacetOCLEnvironment(EFacetOCLEnvironment parent, EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        super((Environment)parent);
        this.facetManager = parent.facetManager;
        this.setFactory(factory);
    }

    public List<EStructuralFeature> getAdditionalAttributes(EClassifier classifier) {
        if (!(classifier instanceof AnyType) && this.facetManager != null) {
            for (FacetSet facetSet : this.facetManager.getManagedFacetSets()) {
                List allFacet = FacetUtils.getAllFacet((FacetSet)facetSet);
                for (Facet facet : allFacet) {
                    this.getAdditionalFacetAttributes(facet, classifier);
                }
            }
        }
        return super.getAdditionalAttributes((Object)classifier);
    }

    private void getAdditionalFacetAttributes(Facet facet, EClassifier classifier) {
        EClass facetClassifier = FacetUtils.getExtendedMetaclass((Facet)facet);
        if (facetClassifier.equals(classifier) || facetClassifier.getInstanceClass() == EObject.class) {
            for (ETypedElement etypeElt : facet.getFacetElements()) {
                this.createAdditionalFacetAttribute(etypeElt, classifier);
            }
            for (Facet extfacet : facet.getExtendedFacets()) {
                this.getAdditionalFacetAttributes(extfacet, classifier);
            }
        }
    }

    private void createAdditionalFacetAttribute(ETypedElement etypeElt, EClassifier classifier) {
        EReference property = null;
        String name = etypeElt.getName();
        if (etypeElt instanceof FacetReference) {
            property = EcoreFactory.eINSTANCE.createEReference();
            if (DEBUG_STATUS) {
                DebugUtils.debug((String)("Create reference from Facet: " + name));
            }
        } else if (etypeElt instanceof FacetAttribute) {
            property = EcoreFactory.eINSTANCE.createEAttribute();
            if (DEBUG_STATUS) {
                DebugUtils.debug((String)("Create attribute from Facet: " + name));
            }
        }
        if (property != null) {
            property.setName(name);
            property.setLowerBound(etypeElt.getLowerBound());
            property.setUpperBound(etypeElt.getUpperBound());
            property.setEType(etypeElt.getEType());
            property.getEAnnotations().add((Object)EFacetOCLEnvironment.createAnnotationEnvironment());
            this.addHelperProperty(classifier, property);
            if (DEBUG_STATUS) {
                DebugUtils.debug((String)("Add additional ocl property: " + property));
            }
        }
    }

    private static EAnnotation createAnnotationEnvironment() {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(ANNOT_ENVIRONMENT);
        return annotation;
    }
}

