/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.ui.quickfix;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.impl.JvmTypeUriFactory;
import org.eclipse.emf.mwe2.runtime.IFactory;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class Mwe2QuickfixProvider
extends DefaultQuickfixProvider {
    private static final Logger logger = Logger.getLogger(Mwe2QuickfixProvider.class);
    @Inject(optional=true)
    private IWorkbench workbench;
    @Inject
    private IWorkspace workspace;

    @Fix(value="abstract_or_interface")
    public void assignValidType(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Define type explicitly", "Choose a compatible type for the component.", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) {
                Component component = (Component)element;
                if (component != null) {
                    IJavaProject project = Mwe2QuickfixProvider.this.findEnclosingProject(element.eResource());
                    Assignment assignment = (Assignment)EcoreUtil2.getContainerOfType((EObject)component, Assignment.class);
                    JvmIdentifiableElement feature = assignment.getFeature();
                    JvmType actualType = component.getActualType();
                    if (feature instanceof JvmOperation) {
                        EList parameters = ((JvmOperation)feature).getParameters();
                        JvmFormalParameter parameter = (JvmFormalParameter)parameters.get(0);
                        actualType = parameter.getParameterType().getType();
                    } else if (feature instanceof DeclaredProperty) {
                        actualType = ((DeclaredProperty)feature).getType();
                    }
                    String type = Mwe2QuickfixProvider.this.chooseType(project, actualType);
                    if (type != null) {
                        JvmType jvmType = Mwe2QuickfixProvider.findJvmType((EObject)component, type);
                        component.setType(jvmType);
                    }
                }
            }
        });
    }

    public static JvmType findJvmType(EObject context, String type) {
        URI fqnURI = JvmTypeUriFactory.getURIForFqn((String)type);
        JvmType jvmType = JvmTypeUriFactory.findJvmType((URI)fqnURI, (EObject)context);
        return jvmType;
    }

    public IJavaProject findEnclosingProject(Resource resource) {
        URI resourceURI = resource.getURI();
        IFile file = this.workspace.getRoot().getFile((IPath)new Path(resourceURI.toPlatformString(true)));
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        IJavaProject result = JavaCore.create((IProject)project);
        return result;
    }

    public String chooseType(IJavaProject project, JvmType actualType) {
        if (project == null) {
            return null;
        }
        IWorkbenchWindow activeWindow = this.workbench.getActiveWorkbenchWindow();
        Shell shell = activeWindow.getShell();
        try {
            Object[] results;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)activeWindow, (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}), (int)2, (boolean)false, (String)"", (TypeSelectionExtension)new ComponentTypeSelectionExtension(actualType.getIdentifier()));
            dialog.setTitle("Select component type");
            dialog.setMessage("Select component type");
            dialog.create();
            if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0) {
                IType result = (IType)results[0];
                return result.getFullyQualifiedName();
            }
            return null;
        }
        catch (JavaModelException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static class ComponentTypeSelectionExtension
    extends TypeSelectionExtension {
        private final String superType;

        public ComponentTypeSelectionExtension(String superType) {
            this.superType = superType;
        }

        public ITypeInfoFilterExtension getFilterExtension() {
            return new ITypeInfoFilterExtension(){

                public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                    return !Flags.isAbstract((int)typeInfoRequestor.getModifiers());
                }
            };
        }

        public ISelectionStatusValidator getSelectionValidator() {
            return new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length == 1) {
                        try {
                            IType[] interfaces;
                            IType type = (IType)selection[0];
                            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                            IType curr = type;
                            while (curr != null) {
                                if (ComponentTypeSelectionExtension.this.superType.equals(curr.getFullyQualifiedName())) {
                                    return Status.OK_STATUS;
                                }
                                curr = hierarchy.getSuperclass(curr);
                            }
                            IType[] iTypeArray = interfaces = hierarchy.getAllSuperInterfaces(type);
                            int n = interfaces.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType intf = iTypeArray[n2];
                                if (IFactory.class.getName().equals(intf.getFullyQualifiedName())) {
                                    return Status.OK_STATUS;
                                }
                                if (ComponentTypeSelectionExtension.this.superType.equals(intf.getFullyQualifiedName())) {
                                    return Status.OK_STATUS;
                                }
                                ++n2;
                            }
                        }
                        catch (JavaModelException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return new Status(4, "org.eclipse.emf.mwe2.language.ui", "The component type must be a subtype of " + ComponentTypeSelectionExtension.this.superType.replace('$', '.'));
                }
            };
        }
    }
}

