/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LineFilterOutputStream
extends FilterOutputStream {
    private final byte[] pattern;
    private final byte[] buffer;
    private int index;
    private final byte[] newline;
    private int newlineIndex;
    private boolean searching;

    public LineFilterOutputStream(OutputStream out, String pattern) {
        this(out, pattern, LineFilterOutputStream.newLine());
    }

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public LineFilterOutputStream(OutputStream out, String pattern, String newLine) {
        super(out);
        this.pattern = pattern.getBytes();
        this.buffer = new byte[pattern.length()];
        this.newline = newLine.getBytes();
        this.index = 0;
        this.newlineIndex = 0;
        this.searching = true;
    }

    public void write(int b) throws IOException {
        if (this.searching) {
            if (this.newline[0] == b) {
                if (this.index == this.pattern.length) {
                    this.index = 0;
                    if (this.newline.length > 1) {
                        ++this.newlineIndex;
                        this.searching = false;
                    } else {
                        this.searching = true;
                    }
                } else {
                    int i = 0;
                    while (i < this.index) {
                        super.write(this.buffer[i]);
                        ++i;
                    }
                    if (this.newline.length > 1) {
                        ++this.newlineIndex;
                        this.searching = false;
                    } else {
                        this.searching = true;
                    }
                    this.index = 0;
                    super.write(b);
                }
            } else if (this.index >= this.pattern.length || this.pattern[this.index] != b) {
                int i = 0;
                while (i < this.index) {
                    super.write(this.buffer[i]);
                    ++i;
                }
                this.searching = false;
                this.index = 0;
                super.write(b);
            } else {
                this.buffer[this.index] = (byte)b;
                ++this.index;
            }
        } else if (this.newline.length > 1 && this.newlineIndex > 0 && b == this.newline[this.newlineIndex]) {
            this.searching = true;
            this.newlineIndex = 0;
            super.write(b);
        } else if (this.newline[0] == b) {
            if (this.newline.length > 1) {
                ++this.newlineIndex;
            } else {
                this.searching = true;
            }
            super.write(b);
        } else {
            super.write(b);
        }
    }

    public void flush() throws IOException {
        if (this.index != this.pattern.length) {
            int i = 0;
            while (i < this.index) {
                super.write(this.buffer[i]);
                ++i;
            }
        }
        super.flush();
    }
}

