/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Francesco Guidieri - initial API and implementation
 * Lorenzo Bettini - refactored to avoid code duplication
 */
package org.eclipse.emf.parsley.dsl.ui.wizard.template;

import org.eclipse.emf.parsley.dsl.ui.wizard.EmfParsleyDslNewProjectFiles;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGeneratorUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Francesco Guidieri
 * @author Lorenzo Bettini - refactored to avoid code duplication
 */
@SuppressWarnings("all")
public class TemplateWizardConfiguration {
  protected final static EmfParsleyDslNewProjectFiles projectFilesGenerator = new EmfParsleyDslNewProjectFiles();
  
  /**
   * The text for the template shown in the list
   */
  private String label;
  
  /**
   * The class that must be extended by the generated part, this
   * must be a fully qualified name.
   */
  private String superClassName;
  
  /**
   * A description for this specific template
   */
  private CharSequence description;
  
  public TemplateWizardConfiguration(final String label, final CharSequence description, final Class<?> superClass) {
    super();
    this.label = label;
    this.description = description;
    this.superClassName = superClass.getName();
  }
  
  public String getLabel() {
    return this.label;
  }
  
  public CharSequence getDescription() {
    return this.description;
  }
  
  protected EmfParsleyDslNewProjectFiles getProjectFilesGenerator() {
    return TemplateWizardConfiguration.projectFilesGenerator;
  }
  
  public String getParsleyModuleContents(final String projectName) {
    String _partClassFQN = this.getPartClassFQN(projectName);
    StringConcatenation _builder = new StringConcatenation();
    String _configuratorContents = this.getConfiguratorContents(projectName);
    _builder.append(_configuratorContents);
    _builder.newLineIfNotEmpty();
    String _resourceManager = this.getResourceManager();
    _builder.append(_resourceManager);
    _builder.newLineIfNotEmpty();
    return TemplateWizardConfiguration.projectFilesGenerator.genDslModuleWithViewPart(projectName, _partClassFQN, _builder.toString()).toString();
  }
  
  public final String getConfiguratorContents(final String projectName) {
    final String elements = this.getConfiguratorElements(projectName);
    boolean _isEmpty = elements.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return TemplateWizardConfiguration.projectFilesGenerator.genConfigurator(elements).toString();
    }
    return "";
  }
  
  /**
   * This should return the elements for the configurator section in
   * the generated Parsley module; the default implementation is empty,
   * subclasses should override it.
   */
  public String getConfiguratorElements(final String projectName) {
    return "";
  }
  
  /**
   * This should return the resourceManager section in
   * the generated Parsley module; the default implementation is empty,
   * subclasses should override it.
   */
  public String getResourceManager() {
    return "";
  }
  
  /**
   * Builds the class name for the part using the project name and
   * the super class.
   */
  public String getPartClassName(final String projectName) {
    String _buildClassNameFromProject = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(projectName);
    String _buildClassNameFromProject_1 = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(this.superClassName);
    return (_buildClassNameFromProject + _buildClassNameFromProject_1);
  }
  
  /**
   * Builds the fully qualified name class name for the part using the project name and
   * the super class.
   */
  public String getPartClassFQN(final String projectName) {
    String _buildFQNFromProject = EmfParsleyProjectFilesGeneratorUtil.buildFQNFromProject(projectName);
    String _buildClassNameFromProject = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(this.superClassName);
    return (_buildFQNFromProject + _buildClassNameFromProject);
  }
  
  /**
   * This should return the contents for the Java Part class.
   */
  public String getContentsForPart(final String projectName) {
    return TemplateWizardConfiguration.projectFilesGenerator.genViewClass(projectName, 
      this.getPartClassName(projectName), 
      this.superClassName).toString();
  }
}
