/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.ISourceVersionDependent;
import org.eclipse.jdt.internal.ui.text.JavaPairMatcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class JavaDoubleClickSelector
extends DefaultTextDoubleClickStrategy
implements ISourceVersionDependent {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected JavaPairMatcher fPairMatcher = new JavaPairMatcher(BRACKETS);
    protected final AtJavaIdentifierDetector fWordDetector = new AtJavaIdentifierDetector();

    protected IRegion findWord(IDocument document, int anchor) {
        return this.fWordDetector.getWordSelection(document, anchor);
    }

    @Override
    public void setSourceVersion(String version) {
        this.fPairMatcher.setSourceVersion(version);
        this.fWordDetector.setSourceVersion(version);
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        IRegion match = this.fPairMatcher.match(document, offset);
        if (match != null && match.getLength() >= 2) {
            return new Region(match.getOffset() + 1, match.getLength() - 2);
        }
        return this.findWord(document, offset);
    }

    private static final class AtJavaIdentifierDetector
    implements ISourceVersionDependent {
        private boolean fSelectAnnotations;
        private static final int UNKNOWN = -1;
        private static final int WS = 0;
        private static final int ID = 1;
        private static final int IDS = 2;
        private static final int AT = 3;
        private static final int FORWARD = 0;
        private static final int BACKWARD = 1;
        private int fState;
        private int fAnchorState;
        private int fDirection;
        private int fStart;
        private int fEnd;

        private AtJavaIdentifierDetector() {
        }

        private void setAnchor(int anchor) {
            this.fState = -1;
            this.fAnchorState = -1;
            this.fDirection = -1;
            this.fStart = anchor;
            this.fEnd = anchor - 1;
        }

        private boolean isAt(char c) {
            return this.fSelectAnnotations && c == '@';
        }

        private boolean isIdentifierStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        private boolean isIdentifierPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        private boolean isWhitespace(char c) {
            return this.fSelectAnnotations && Character.isWhitespace(c);
        }

        @Override
        public void setSourceVersion(String version) {
            this.fSelectAnnotations = JavaCore.compareJavaVersions((String)"1.5", (String)version) <= 0;
        }

        private boolean backward(char c, int offset) {
            this.checkDirection(1);
            switch (this.fState) {
                case 3: {
                    return false;
                }
                case 2: {
                    if (this.isAt(c)) {
                        this.fStart = offset;
                        this.fState = 3;
                        return false;
                    }
                    if (this.isWhitespace(c)) {
                        this.fState = 0;
                        return true;
                    }
                    if (this.isIdentifierStart(c)) {
                        this.fStart = offset;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fStart = offset;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case 1: {
                    if (this.isIdentifierStart(c)) {
                        this.fStart = offset;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fStart = offset;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case 0: {
                    if (this.isWhitespace(c)) {
                        return true;
                    }
                    if (this.isAt(c)) {
                        this.fStart = offset;
                        this.fState = 3;
                        return false;
                    }
                    return false;
                }
                case -1: {
                    if (c == '.') {
                        this.fEnd = offset - 1;
                        this.fAnchorState = this.fState = 2;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean forward(char c, int offset) {
            this.checkDirection(0);
            switch (this.fState) {
                case 0: 
                case 3: {
                    if (this.isWhitespace(c)) {
                        this.fState = 0;
                        return true;
                    }
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = offset;
                        this.fState = 2;
                        return true;
                    }
                    return false;
                }
                case 1: 
                case 2: {
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = offset;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fEnd = offset;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case -1: {
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = offset;
                        this.fAnchorState = this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fEnd = offset;
                        this.fAnchorState = this.fState = 1;
                        return true;
                    }
                    if (this.isWhitespace(c)) {
                        this.fAnchorState = this.fState = 0;
                        return true;
                    }
                    if (this.isAt(c)) {
                        this.fStart = offset;
                        this.fAnchorState = this.fState = 3;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private void checkDirection(int direction) {
            if (this.fDirection == direction) {
                return;
            }
            if (direction == 0) {
                this.fState = this.fStart <= this.fEnd ? this.fAnchorState : -1;
            } else if (direction == 1) {
                this.fState = this.fEnd >= this.fStart ? this.fAnchorState : -1;
            }
            this.fDirection = direction;
        }

        public IRegion getWordSelection(IDocument document, int anchor) {
            try {
                char c;
                int max = document.getLength();
                this.setAnchor(anchor);
                int offset = anchor;
                while (offset < max) {
                    c = document.getChar(offset);
                    if (!this.forward(c, offset)) break;
                    ++offset;
                }
                offset = anchor;
                while (offset >= 0) {
                    c = document.getChar(offset);
                    if (!this.backward(c, offset)) break;
                    --offset;
                }
                return new Region(this.fStart, this.fEnd - this.fStart + 1);
            }
            catch (BadLocationException badLocationException) {
                return new Region(anchor, 0);
            }
        }
    }
}

